/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.net.http;

import java.security.Principal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.net.connector.Authenticator;
import org.exolab.jms.net.connector.ConnectionFactory;
import org.exolab.jms.net.connector.ConnectionManager;
import org.exolab.jms.net.connector.ConnectionRequestInfo;
import org.exolab.jms.net.connector.ManagedConnection;
import org.exolab.jms.net.connector.ManagedConnectionAcceptor;
import org.exolab.jms.net.connector.ResourceException;
import org.exolab.jms.net.http.AbstractHTTPManagedConnectionFactory;
import org.exolab.jms.net.http.HTTPRequestInfo;
import org.exolab.jms.net.http.HTTPSConnectionFactory;
import org.exolab.jms.net.http.HTTPSManagedConnection;
import org.exolab.jms.net.http.HTTPSManagedConnectionAcceptor;
import org.exolab.jms.net.socket.SocketRequestInfo;

public class HTTPSManagedConnectionFactory
extends AbstractHTTPManagedConnectionFactory {
    private static boolean _sslInit = false;
    private static final String PROTOCOL_HANDLER_PKGS = "java.protocol.handler.pkgs";
    private static final String SUN_PACKAGE = "com.sun.net.ssl.internal.www.protocol";
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$net$http$HTTPSManagedConnectionFactory == null ? (class$org$exolab$jms$net$http$HTTPSManagedConnectionFactory = HTTPSManagedConnectionFactory.class$("org.exolab.jms.net.http.HTTPSManagedConnectionFactory")) : class$org$exolab$jms$net$http$HTTPSManagedConnectionFactory));
    static /* synthetic */ Class class$org$exolab$jms$net$http$HTTPSManagedConnectionFactory;
    static /* synthetic */ Class class$org$exolab$jms$net$http$HTTPRequestInfo;
    static /* synthetic */ Class class$org$exolab$jms$net$socket$SocketRequestInfo;

    public ConnectionFactory createConnectionFactory(ConnectionManager manager) throws ResourceException {
        return new HTTPSConnectionFactory(this, manager);
    }

    public ManagedConnection createManagedConnection(Principal principal, ConnectionRequestInfo info) throws ResourceException {
        if (!(info instanceof HTTPRequestInfo)) {
            throw new ResourceException("Argument 'info' must be of type " + (class$org$exolab$jms$net$http$HTTPRequestInfo == null ? (class$org$exolab$jms$net$http$HTTPRequestInfo = HTTPSManagedConnectionFactory.class$("org.exolab.jms.net.http.HTTPRequestInfo")) : class$org$exolab$jms$net$http$HTTPRequestInfo).getName());
        }
        HTTPSManagedConnectionFactory.initSSL();
        return new HTTPSManagedConnection(principal, (HTTPRequestInfo)info);
    }

    public ManagedConnectionAcceptor createManagedConnectionAcceptor(Authenticator authenticator, ConnectionRequestInfo info) throws ResourceException {
        if (!(info instanceof SocketRequestInfo)) {
            throw new ResourceException("Argument 'info' must be of type " + (class$org$exolab$jms$net$socket$SocketRequestInfo == null ? (class$org$exolab$jms$net$socket$SocketRequestInfo = HTTPSManagedConnectionFactory.class$("org.exolab.jms.net.socket.SocketRequestInfo")) : class$org$exolab$jms$net$socket$SocketRequestInfo).getName());
        }
        return new HTTPSManagedConnectionAcceptor(authenticator, (SocketRequestInfo)info);
    }

    private static synchronized void initSSL() {
        block7: {
            if (!_sslInit) {
                try {
                    String value = System.getProperty(PROTOCOL_HANDLER_PKGS);
                    if (value == null) {
                        value = SUN_PACKAGE;
                    } else if (value.indexOf(SUN_PACKAGE) == -1) {
                        if (value.length() > 0) {
                            value = value + "|";
                        }
                        value = value + SUN_PACKAGE;
                    }
                    System.setProperty(PROTOCOL_HANDLER_PKGS, SUN_PACKAGE);
                    _sslInit = true;
                }
                catch (SecurityException exception) {
                    if (!_log.isDebugEnabled()) break block7;
                    _log.debug((Object)"Failed to set property=java.protocol.handler.pkgs", (Throwable)exception);
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

