/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.net.multiplexer;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.rmi.MarshalException;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.net.connector.Request;
import org.exolab.jms.net.connector.Response;
import org.exolab.jms.net.multiplexer.Constants;
import org.exolab.jms.net.multiplexer.MultiplexInputStream;
import org.exolab.jms.net.multiplexer.MultiplexOutputStream;
import org.exolab.jms.net.multiplexer.Multiplexer;

class Channel
implements Constants {
    private int _id;
    private Multiplexer _multiplexer;
    private MultiplexInputStream _in;
    private MultiplexOutputStream _out;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$net$multiplexer$Channel == null ? (class$org$exolab$jms$net$multiplexer$Channel = Channel.class$("org.exolab.jms.net.multiplexer.Channel")) : class$org$exolab$jms$net$multiplexer$Channel));
    static /* synthetic */ Class class$org$exolab$jms$net$multiplexer$Channel;

    public Channel(int id, Multiplexer multiplexer, MultiplexInputStream in, MultiplexOutputStream out) {
        this._id = id;
        this._multiplexer = multiplexer;
        this._in = in;
        this._out = out;
    }

    public int getId() {
        return this._id;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Response invoke(Request request) throws RemoteException {
        Response response;
        block18: {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("invoke() [channel=" + this._id + "]"));
            }
            ObjectOutputStream out = null;
            try {
                try {
                    this._out.setType((byte)48);
                    out = new ObjectOutputStream(this._out);
                    request.write(out);
                }
                catch (IOException exception) {
                    throw new MarshalException("Failed to marshal call", exception);
                }
                catch (Exception exception) {
                    throw new MarshalException("Failed to marshal call", exception);
                }
                Object var7_3 = null;
                if (out == null) break block18;
            }
            catch (Throwable throwable) {
                Object var7_4 = null;
                if (out == null) throw throwable;
                try {
                    out.close();
                    throw throwable;
                }
                catch (IOException ignore) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException ignore) {}
            out.close();
        }
        ObjectInputStream in = null;
        try {
            try {
                in = new ObjectInputStream(this._in);
                response = Response.read(in, request.getMethod());
            }
            catch (ClassNotFoundException exception) {
                throw new UnmarshalException("Failed to unmarshal response", exception);
            }
            catch (IOException exception) {
                throw new UnmarshalException("Failed to unmarshal response", exception);
            }
            Object var10_14 = null;
            {
            }
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            try {
                if (in == null) throw throwable;
                in.close();
                throw throwable;
            }
            catch (IOException ignore) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ignore) {}
        if (in != null) {
            in.close();
        }
        if (!_log.isDebugEnabled()) return response;
        _log.debug((Object)("invoke() [channel=" + this._id + "] - end"));
        return response;
    }

    public synchronized Request readRequest() throws IOException {
        ObjectInputStream in = new ObjectInputStream(this._in);
        Request request = Request.read(in);
        return request;
    }

    public synchronized void writeResponse(Response response) throws IOException {
        this._out.setType((byte)49);
        ObjectOutputStream out = new ObjectOutputStream(this._out);
        try {
            response.write(out);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            out.close();
            throw throwable;
        }
        out.close();
    }

    public void disconnected() {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("disconnected [channel=" + this._id + "]"));
        }
        this._in.disconnected();
        this._out.disconnected();
    }

    public MultiplexInputStream getMultiplexInputStream() {
        return this._in;
    }

    public MultiplexOutputStream getMultiplexOutputStream() {
        return this._out;
    }

    public void release() {
        this._multiplexer.release(this);
    }

    public void close() throws IOException {
        if (this._multiplexer != null) {
            try {
                this._multiplexer.close(this);
                Object var2_1 = null;
                this._multiplexer = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this._multiplexer = null;
                try {
                    this._in.destroy();
                }
                catch (IOException ignore) {
                    // empty catch block
                }
                try {
                    this._out.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                this._in.destroy();
            }
            catch (IOException ignore) {
                // empty catch block
            }
            try {
                this._out.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void destroy() {
        try {
            this.close();
        }
        catch (IOException exception) {
            _log.debug((Object)"close() failed", (Throwable)exception);
        }
    }

    public String toString() {
        return "Channel[id=" + this._id + ", out=" + this._out + ", in=" + this._in + " ]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

