/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.net.orb;

import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.StubNotFoundException;
import java.rmi.server.ExportException;
import java.rmi.server.ObjID;
import java.util.HashMap;
import java.util.Map;
import org.exolab.jms.net.connector.Caller;
import org.exolab.jms.net.connector.CallerListener;
import org.exolab.jms.net.orb.ORB;
import org.exolab.jms.net.orb.ObjectRef;
import org.exolab.jms.net.proxy.Proxy;
import org.exolab.jms.net.registry.LocalRegistry;
import org.exolab.jms.net.registry.Registry;
import org.exolab.jms.net.uri.InvalidURIException;
import org.exolab.jms.net.uri.URI;
import org.exolab.jms.net.uri.URIHelper;

public abstract class AbstractORB
implements ORB {
    private HashMap _objIDMap = new HashMap();
    private HashMap _objectMap = new HashMap();
    private final Map _properties;
    private final String _defaultURI;
    private HashMap _routes = new HashMap();
    private ClassLoader _loader;
    static /* synthetic */ Class class$org$exolab$jms$net$proxy$Proxy;

    public AbstractORB(ClassLoader loader, Map properties) {
        if (loader == null) {
            throw new IllegalArgumentException("Argument 'loader' is null");
        }
        this._loader = loader;
        if (properties != null) {
            this._properties = properties;
            this._defaultURI = (String)properties.get("org.exolab.jms.net.orb.provider.uri");
        } else {
            this._properties = new HashMap();
            this._defaultURI = null;
        }
    }

    public synchronized void addRoute(String uri, String toURI) throws RemoteException {
        if (uri == null) {
            throw new IllegalArgumentException("Argument 'uri' is null");
        }
        if (toURI == null) {
            throw new IllegalArgumentException("Argument 'toURI' is null");
        }
        this._routes.put(URIHelper.parse(uri), URIHelper.parse(toURI));
    }

    public synchronized Proxy getProxy(Object object, String uri) throws NoSuchObjectException {
        ObjectRef ref = (ObjectRef)this._objectMap.get(object);
        if (ref == null) {
            throw new NoSuchObjectException("Object not exported");
        }
        URI parsed = null;
        if (uri != null) {
            try {
                parsed = URIHelper.parse(uri);
            }
            catch (InvalidURIException exception) {
                throw new NoSuchObjectException(exception.getMessage());
            }
        }
        return ref.getProxy(parsed);
    }

    public synchronized Object getObject(ObjID objID, String uri) throws NoSuchObjectException {
        ObjectRef ref = (ObjectRef)this._objIDMap.get(objID);
        if (ref == null) {
            throw new NoSuchObjectException("Object not exported");
        }
        return ref.getObject();
    }

    public Proxy exportObject(Object object) throws ExportException, StubNotFoundException {
        return this.exportObject(object, this._defaultURI);
    }

    public synchronized Proxy exportObject(Object object, String uri) throws ExportException, StubNotFoundException {
        if (object == null) {
            throw new IllegalArgumentException("Argument 'object' is null");
        }
        if (uri == null) {
            throw new IllegalArgumentException("Argument 'uri' is null");
        }
        URI parsed = null;
        try {
            parsed = URIHelper.parse(uri);
        }
        catch (InvalidURIException exception) {
            throw new ExportException(exception.getMessage(), exception);
        }
        Proxy proxy = null;
        ObjectRef ref = (ObjectRef)this._objectMap.get(object);
        if (ref != null) {
            proxy = this.addProxy(ref, parsed, object, ref.getProxyClass());
        } else {
            ObjID objID = new ObjID();
            proxy = this.doExport(object, objID, parsed, this.getProxyClass(object));
        }
        return proxy;
    }

    public Proxy exportObject(Object object, ObjID objID) throws ExportException, StubNotFoundException {
        return this.exportObject(object, objID, this._defaultURI);
    }

    public synchronized Proxy exportObject(Object object, ObjID objID, String uri) throws ExportException, StubNotFoundException {
        if (object == null) {
            throw new IllegalArgumentException("Argument 'object' is null");
        }
        if (objID == null) {
            throw new IllegalArgumentException("Argument 'objID' is null");
        }
        if (uri == null) {
            throw new IllegalArgumentException("Argument 'uri' is null");
        }
        URI parsed = null;
        try {
            parsed = URIHelper.parse(uri);
        }
        catch (InvalidURIException exception) {
            throw new ExportException(exception.getMessage(), exception);
        }
        Proxy proxy = null;
        ObjectRef ref = (ObjectRef)this._objectMap.get(object);
        proxy = ref != null ? this.addProxy(ref, parsed, object, ref.getProxyClass()) : this.doExport(object, objID, parsed, this.getProxyClass(object));
        return proxy;
    }

    public Proxy exportObjectTo(Object object, String uri) throws ExportException, StubNotFoundException {
        return this.exportObjectTo(object, uri, null, null);
    }

    public Proxy exportObjectTo(Object object, String uri, String principal, String credentials) throws ExportException, StubNotFoundException {
        if (object == null) {
            throw new IllegalArgumentException("Argument 'object' is null");
        }
        if (uri == null) {
            throw new IllegalArgumentException("Argument 'uri' is null");
        }
        URI remoteURI = null;
        URI localURI = null;
        try {
            remoteURI = URIHelper.parse(uri);
        }
        catch (InvalidURIException exception) {
            throw new ExportException(exception.getMessage(), exception);
        }
        localURI = this.connect(remoteURI, principal, credentials);
        return this.doExportTo(object, localURI);
    }

    public synchronized void unexportObject(Object object) throws NoSuchObjectException {
        ObjectRef ref = (ObjectRef)this._objectMap.remove(object);
        if (ref == null) {
            throw new NoSuchObjectException("Object not exported");
        }
        this._objIDMap.remove(ref.getObjID());
    }

    protected abstract URI connect(URI var1, String var2, String var3) throws ExportException;

    protected abstract void accept(URI var1) throws ExportException;

    protected ClassLoader getProxyClassLoader() {
        return this._loader;
    }

    protected Map getProperties() {
        return this._properties;
    }

    protected Proxy doExportTo(Object object, URI uri) throws ExportException, StubNotFoundException {
        Proxy proxy = null;
        ObjectRef ref = (ObjectRef)this._objectMap.get(object);
        if (ref != null) {
            proxy = this.addProxyTo(ref, uri, object, ref.getProxyClass());
        } else {
            ObjID objID = new ObjID();
            proxy = this.doExportTo(object, objID, uri, this.getProxyClass(object));
        }
        return proxy;
    }

    protected int getExported() {
        return this._objectMap.size();
    }

    private Proxy doExport(Object object, ObjID objID, URI uri, Class proxyClass) throws ExportException {
        this.accept(uri);
        ObjectRef ref = new ObjectRef(objID, object, proxyClass);
        Proxy proxy = ref.addProxy(this.getRoute(uri));
        this._objIDMap.put(objID, ref);
        this._objectMap.put(object, ref);
        return proxy;
    }

    private Proxy doExportTo(Object object, ObjID objID, URI uri, Class proxyClass) throws ExportException {
        ObjectRef ref = new ObjectRef(objID, object, proxyClass);
        Proxy proxy = ref.addProxy(this.getRoute(uri));
        this._objIDMap.put(objID, ref);
        this._objectMap.put(object, ref);
        return proxy;
    }

    private Proxy addProxy(ObjectRef ref, URI uri, Object object, Class proxyClass) throws ExportException {
        if (object != ref.getObject()) {
            throw new ExportException("Cannot export object on URI=" + uri + ": object mismatch");
        }
        if (proxyClass != ref.getProxyClass()) {
            throw new ExportException("Cannot export object on URI=" + uri + ": proxy class mismatch");
        }
        this.accept(uri);
        return ref.addProxy(this.getRoute(uri));
    }

    private Proxy addProxyTo(ObjectRef ref, URI uri, Object object, Class proxyClass) throws ExportException {
        if (object != ref.getObject()) {
            throw new ExportException("Cannot export object on URI=" + uri + ": object mismatch");
        }
        if (proxyClass != ref.getProxyClass()) {
            throw new ExportException("Cannot export object on URI=" + uri + ": proxy class mismatch");
        }
        return ref.addProxy(uri);
    }

    private Class getProxyClass(Object object) throws StubNotFoundException {
        return this.getProxyClass(object.getClass());
    }

    private Class getProxyClass(Class clazz) throws StubNotFoundException {
        String proxyName = clazz.getName() + "__Proxy";
        Class proxyClass = null;
        try {
            proxyClass = this._loader.loadClass(proxyName);
            if (!(class$org$exolab$jms$net$proxy$Proxy == null ? (class$org$exolab$jms$net$proxy$Proxy = AbstractORB.class$("org.exolab.jms.net.proxy.Proxy")) : class$org$exolab$jms$net$proxy$Proxy).isAssignableFrom(proxyClass)) {
                throw new StubNotFoundException(proxyName);
            }
        }
        catch (ClassNotFoundException exception) {
            Class superClass = clazz.getSuperclass();
            if (superClass != null && !superClass.isInterface()) {
                proxyClass = this.getProxyClass(superClass);
            }
            throw new StubNotFoundException(proxyName);
        }
        return proxyClass;
    }

    private URI getRoute(URI uri) {
        URI result = (URI)this._routes.get(uri);
        return result == null ? uri : result;
    }

    public abstract void shutdown() throws RemoteException;

    public abstract void removeCallerListener(String var1, CallerListener var2) throws RemoteException;

    public abstract void addCallerListener(String var1, CallerListener var2) throws RemoteException;

    public abstract Caller getCaller() throws RemoteException;

    public abstract Proxy exportObjectTo(Object var1) throws ExportException, StubNotFoundException;

    public abstract Registry getRegistry(Map var1) throws RemoteException;

    public abstract LocalRegistry getRegistry() throws RemoteException;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

