/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.net.rmi;

import java.security.Principal;
import java.util.Iterator;
import java.util.List;
import org.exolab.jms.net.connector.Authenticator;
import org.exolab.jms.net.connector.ConnectionFactory;
import org.exolab.jms.net.connector.ConnectionManager;
import org.exolab.jms.net.connector.ConnectionRequestInfo;
import org.exolab.jms.net.connector.ManagedConnection;
import org.exolab.jms.net.connector.ManagedConnectionAcceptor;
import org.exolab.jms.net.connector.ManagedConnectionFactory;
import org.exolab.jms.net.connector.ResourceException;
import org.exolab.jms.net.rmi.RMIConnectionFactory;
import org.exolab.jms.net.rmi.RMIManagedConnection;
import org.exolab.jms.net.rmi.RMIManagedConnectionAcceptor;
import org.exolab.jms.net.rmi.RMIRequestInfo;
import org.exolab.jms.net.uri.URI;
import org.exolab.jms.net.uri.URIHelper;

public class RMIManagedConnectionFactory
implements ManagedConnectionFactory {
    static /* synthetic */ Class class$org$exolab$jms$net$rmi$RMIRequestInfo;

    public ConnectionFactory createConnectionFactory(ConnectionManager manager) throws ResourceException {
        return new RMIConnectionFactory(this, manager);
    }

    public ManagedConnection createManagedConnection(Principal principal, ConnectionRequestInfo info) throws ResourceException {
        if (!(info instanceof RMIRequestInfo)) {
            throw new ResourceException("Argument 'info' must be of type " + (class$org$exolab$jms$net$rmi$RMIRequestInfo == null ? (class$org$exolab$jms$net$rmi$RMIRequestInfo = RMIManagedConnectionFactory.class$("org.exolab.jms.net.rmi.RMIRequestInfo")) : class$org$exolab$jms$net$rmi$RMIRequestInfo).getName());
        }
        return new RMIManagedConnection(principal, (RMIRequestInfo)info);
    }

    public ManagedConnectionAcceptor createManagedConnectionAcceptor(Authenticator authenticator, ConnectionRequestInfo info) throws ResourceException {
        if (!(info instanceof RMIRequestInfo)) {
            throw new ResourceException("Argument 'info' must be of type " + (class$org$exolab$jms$net$rmi$RMIRequestInfo == null ? (class$org$exolab$jms$net$rmi$RMIRequestInfo = RMIManagedConnectionFactory.class$("org.exolab.jms.net.rmi.RMIRequestInfo")) : class$org$exolab$jms$net$rmi$RMIRequestInfo).getName());
        }
        RMIRequestInfo rmiInfo = (RMIRequestInfo)info;
        return new RMIManagedConnectionAcceptor(authenticator, rmiInfo);
    }

    public ManagedConnection matchManagedConnections(List connections, Principal principal, ConnectionRequestInfo info) throws ResourceException {
        RMIManagedConnection result = null;
        if (info instanceof RMIRequestInfo) {
            RMIRequestInfo requestInfo = (RMIRequestInfo)info;
            URI uri = URIHelper.convertHostToAddress(requestInfo.getURI());
            Iterator iterator = connections.iterator();
            while (iterator.hasNext()) {
                RMIManagedConnection connection = (RMIManagedConnection)iterator.next();
                if (!connection.hasPrincipal(principal) || !uri.equals(connection.getRemoteURI())) continue;
                result = connection;
                break;
            }
        }
        return result;
    }

    public ManagedConnectionAcceptor matchManagedConnectionAcceptors(List acceptors, ConnectionRequestInfo info) throws ResourceException {
        RMIManagedConnectionAcceptor result = null;
        if (info instanceof RMIRequestInfo) {
            RMIRequestInfo requestInfo = (RMIRequestInfo)info;
            URI uri = URIHelper.convertHostToAddress(requestInfo.getURI());
            Iterator iterator = acceptors.iterator();
            while (iterator.hasNext()) {
                RMIManagedConnectionAcceptor acceptor = (RMIManagedConnectionAcceptor)iterator.next();
                if (!uri.equals(acceptor.getURI())) continue;
                result = acceptor;
                break;
            }
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

