/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.net.rmi;

import org.exolab.jms.net.connector.ResourceException;
import org.exolab.jms.net.connector.URIRequestInfo;
import org.exolab.jms.net.uri.URI;
import org.exolab.jms.net.util.Properties;

public class RMIRequestInfo
extends URIRequestInfo {
    private boolean _embedRegistry = true;
    protected static final String EMBED_REGISTRY = "embedRegistry";

    public RMIRequestInfo(URI uri) {
        super(uri);
    }

    public RMIRequestInfo(URI uri, Properties properties) throws ResourceException {
        super(uri);
        this.setEmbedRegistry(properties.getBoolean(EMBED_REGISTRY, true));
    }

    public void setEmbedRegistry(boolean embedded) {
        this._embedRegistry = embedded;
    }

    public boolean getEmbedRegistry() {
        return this._embedRegistry;
    }

    public void export(Properties properties) {
        super.export(properties);
        properties.set(EMBED_REGISTRY, this.getEmbedRegistry());
    }

    public boolean equals(Object other) {
        boolean equal = super.equals(other);
        if (equal && other instanceof RMIRequestInfo) {
            RMIRequestInfo info = (RMIRequestInfo)other;
            if (this._embedRegistry == info._embedRegistry) {
                equal = true;
            }
        } else {
            equal = false;
        }
        return equal;
    }
}

