/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.net.socket;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.exolab.jms.net.multiplexer.Endpoint;
import org.exolab.jms.net.uri.URI;
import org.exolab.jms.net.uri.URIHelper;

public class SocketEndpoint
implements Endpoint {
    private final URI _uri;
    private Socket _socket;
    private InputStream _in;
    private OutputStream _out;

    public SocketEndpoint(String scheme, Socket socket) throws IOException {
        this._uri = URIHelper.create(scheme, socket.getInetAddress().getHostAddress(), socket.getPort());
        this._socket = socket;
        this._in = socket.getInputStream();
        this._out = socket.getOutputStream();
    }

    public URI getURI() {
        return this._uri;
    }

    public InputStream getInputStream() {
        return this._in;
    }

    public OutputStream getOutputStream() {
        return this._out;
    }

    public void close() throws IOException {
        this._socket.close();
    }
}

