/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.net.socket;

import java.io.IOException;
import java.net.Socket;
import java.security.Principal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.net.connector.Authenticator;
import org.exolab.jms.net.connector.ConnectException;
import org.exolab.jms.net.connector.ResourceException;
import org.exolab.jms.net.multiplexer.Endpoint;
import org.exolab.jms.net.multiplexer.MultiplexedManagedConnection;
import org.exolab.jms.net.socket.SocketEndpoint;
import org.exolab.jms.net.socket.SocketRequestInfo;
import org.exolab.jms.net.uri.InvalidURIException;
import org.exolab.jms.net.uri.URI;
import org.exolab.jms.net.uri.URIHelper;

public abstract class SocketManagedConnection
extends MultiplexedManagedConnection {
    private Socket _socket;
    private URI _remoteURI;
    private URI _localURI;
    private URI _alternativeURI;
    protected static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$net$socket$SocketManagedConnection == null ? (class$org$exolab$jms$net$socket$SocketManagedConnection = SocketManagedConnection.class$("org.exolab.jms.net.socket.SocketManagedConnection")) : class$org$exolab$jms$net$socket$SocketManagedConnection));
    static /* synthetic */ Class class$org$exolab$jms$net$socket$SocketManagedConnection;

    public SocketManagedConnection(Principal principal, SocketRequestInfo info) throws ResourceException {
        super(principal);
        if (info == null) {
            throw new IllegalArgumentException("Argument 'info' is null");
        }
        Socket socket = this.createSocket(info);
        this.init(info.getURI(), socket);
    }

    public SocketManagedConnection(URI uri, Socket socket, Authenticator authenticator) throws ResourceException {
        super(authenticator);
        if (uri == null) {
            throw new IllegalArgumentException("Argument 'uri' is null");
        }
        if (socket == null) {
            throw new IllegalArgumentException("Argument 'socket' is null");
        }
        if (authenticator == null) {
            throw new IllegalArgumentException("Argument 'authenticator' is null");
        }
        this.init(uri, socket);
    }

    public URI getRemoteURI() {
        return this._remoteURI;
    }

    public URI getLocalURI() {
        return this._localURI;
    }

    public URI getAlternativeURI() {
        return this._alternativeURI;
    }

    protected Socket createSocket(SocketRequestInfo info) throws ResourceException {
        Socket result;
        try {
            result = this.createSocketProtected(info.getHost(), info.getPort());
            this._alternativeURI = info.getAlternativeURI();
        }
        catch (ResourceException exception) {
            this._alternativeURI = info.getURI();
            URI uri = info.getAlternativeURI();
            if (uri == null) {
                throw exception;
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Failed to connect using URI=" + info.getURI() + ", attempting URI=" + uri));
            }
            result = this.createSocketProtected(uri.getHost(), uri.getPort());
        }
        return result;
    }

    protected Socket createSocket(String host, int port) throws IOException {
        Socket socket = new Socket(host, port);
        socket.setTcpNoDelay(true);
        return socket;
    }

    protected Endpoint createEndpoint() throws IOException {
        return new SocketEndpoint(this._remoteURI.getScheme(), this._socket);
    }

    protected void init(URI uri, Socket socket) throws ResourceException {
        this._socket = socket;
        try {
            String localHost = socket.getLocalAddress().getHostAddress();
            int localPort = socket.getLocalPort();
            this._localURI = URIHelper.create(uri.getScheme(), localHost, localPort);
            String remoteHost = socket.getInetAddress().getHostAddress();
            int remotePort = socket.getPort();
            this._remoteURI = URIHelper.create(uri.getScheme(), remoteHost, remotePort);
        }
        catch (InvalidURIException exception) {
            throw new ResourceException("Failed to create URI", exception);
        }
    }

    private Socket createSocketProtected(String host, int port) throws ResourceException {
        try {
            return this.createSocket(host, port);
        }
        catch (Exception exception) {
            String msg = "Failed to connect to " + host + ":" + port;
            _log.debug((Object)msg, (Throwable)exception);
            if (exception instanceof java.net.ConnectException) {
                throw new ConnectException(msg, exception);
            }
            throw new ResourceException(msg, exception);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

