/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.net.socket;

import java.security.Principal;
import java.util.Iterator;
import java.util.List;
import org.exolab.jms.net.connector.Authenticator;
import org.exolab.jms.net.connector.ConnectionFactory;
import org.exolab.jms.net.connector.ConnectionManager;
import org.exolab.jms.net.connector.ConnectionRequestInfo;
import org.exolab.jms.net.connector.ManagedConnection;
import org.exolab.jms.net.connector.ManagedConnectionAcceptor;
import org.exolab.jms.net.connector.ManagedConnectionFactory;
import org.exolab.jms.net.connector.ResourceException;
import org.exolab.jms.net.socket.SocketManagedConnection;
import org.exolab.jms.net.socket.SocketManagedConnectionAcceptor;
import org.exolab.jms.net.socket.SocketRequestInfo;
import org.exolab.jms.net.uri.URI;
import org.exolab.jms.net.uri.URIHelper;

public abstract class SocketManagedConnectionFactory
implements ManagedConnectionFactory {
    public ManagedConnection matchManagedConnections(List connections, Principal principal, ConnectionRequestInfo info) throws ResourceException {
        SocketManagedConnection result = null;
        if (info instanceof SocketRequestInfo) {
            SocketRequestInfo requestInfo = (SocketRequestInfo)info;
            URI uri = URIHelper.convertHostToAddress(requestInfo.getURI());
            URI altURI = requestInfo.getAlternativeURI();
            if (altURI != null) {
                altURI = URIHelper.convertHostToAddress(altURI);
            }
            Iterator iterator = connections.iterator();
            while (iterator.hasNext()) {
                SocketManagedConnection connection = (SocketManagedConnection)iterator.next();
                if (!connection.hasPrincipal(principal)) continue;
                URI remote = connection.getRemoteURI();
                URI local = connection.getLocalURI();
                URI remoteAlt = connection.getAlternativeURI();
                if (!remote.equals(uri) && !local.equals(uri) && !remote.equals(altURI) && !local.equals(altURI) && (remoteAlt == null || !remoteAlt.equals(uri) && !remoteAlt.equals(altURI))) continue;
                result = connection;
                break;
            }
        }
        return result;
    }

    public ManagedConnectionAcceptor matchManagedConnectionAcceptors(List acceptors, ConnectionRequestInfo info) throws ResourceException {
        SocketManagedConnectionAcceptor result = null;
        if (info instanceof SocketRequestInfo) {
            Iterator iterator = acceptors.iterator();
            while (iterator.hasNext()) {
                SocketManagedConnectionAcceptor acceptor = (SocketManagedConnectionAcceptor)iterator.next();
                if (!info.equals(acceptor.getRequestInfo())) continue;
                result = acceptor;
                break;
            }
        }
        return result;
    }

    public abstract ManagedConnectionAcceptor createManagedConnectionAcceptor(Authenticator var1, ConnectionRequestInfo var2) throws ResourceException;

    public abstract ManagedConnection createManagedConnection(Principal var1, ConnectionRequestInfo var2) throws ResourceException;

    public abstract ConnectionFactory createConnectionFactory(ConnectionManager var1) throws ResourceException;
}

