/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.net.socket;

import java.util.Map;
import org.exolab.jms.net.connector.ResourceException;
import org.exolab.jms.net.connector.URIRequestInfo;
import org.exolab.jms.net.uri.InvalidURIException;
import org.exolab.jms.net.uri.URI;
import org.exolab.jms.net.uri.URIHelper;
import org.exolab.jms.net.util.Properties;

public class SocketRequestInfo
extends URIRequestInfo {
    private String _alternativeHost;
    private int _connectionRequestQueueSize = 50;
    private boolean _bindAll = true;
    private static final String ALTERNATIVE_HOST = "alt";
    private static final String BIND_ALL = "bindAll";

    public SocketRequestInfo(URI uri) throws ResourceException {
        super(URIHelper.getURISansQuery(uri));
        this.init(uri);
    }

    public SocketRequestInfo(URI uri, Properties properties) throws ResourceException {
        super(URIHelper.getURISansQuery(uri));
        this.setBindAll(properties.getBoolean(BIND_ALL, this._bindAll));
        this.init(uri);
    }

    public void setAlternativeHost(String host) {
        this._alternativeHost = host;
    }

    public String getAlternativeHost() {
        return this._alternativeHost;
    }

    public URI getAlternativeURI() throws ResourceException {
        URI result = null;
        if (this._alternativeHost != null) {
            result = new URI(this.getURI());
            try {
                result.setHost(this._alternativeHost);
            }
            catch (URI.MalformedURIException exception) {
                throw new ResourceException(exception);
            }
        }
        return result;
    }

    public void setConnectionRequestQueueSize(int size) {
        this._connectionRequestQueueSize = size;
    }

    public int getConnectionRequestQueueSize() {
        return this._connectionRequestQueueSize;
    }

    public void setBindAll(boolean bindAll) {
        this._bindAll = bindAll;
    }

    public boolean getBindAll() {
        return this._bindAll;
    }

    public void export(Properties properties) {
        String uri = this.getURI().toString();
        if (this._alternativeHost != null) {
            uri = uri + "?alt=" + this._alternativeHost;
        }
        properties.set("org.exolab.jms.net.orb.provider.uri", uri);
        properties.set(BIND_ALL, this.getBindAll());
    }

    public boolean equals(Object other) {
        boolean equal = false;
        if (other instanceof SocketRequestInfo && super.equals(other)) {
            SocketRequestInfo info = (SocketRequestInfo)other;
            if (this.equals(this._alternativeHost, info._alternativeHost) && this._connectionRequestQueueSize == info._connectionRequestQueueSize && this._bindAll == info._bindAll) {
                equal = true;
            }
        }
        return equal;
    }

    protected boolean equals(Object o1, Object o2) {
        boolean equal;
        boolean bl = equal = o1 == null && o2 == null;
        if (!equal && o1 != null && o1.equals(o2)) {
            equal = true;
        }
        return equal;
    }

    private void init(URI uri) throws ResourceException {
        String query = uri.getQueryString();
        if (query != null) {
            Map properties;
            try {
                properties = URIHelper.parseQuery(query);
            }
            catch (InvalidURIException exception) {
                throw new ResourceException(exception);
            }
            String host = (String)properties.get(ALTERNATIVE_HOST);
            this.setAlternativeHost(host);
        }
    }
}

