/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.net.tcp;

import java.io.IOException;
import java.net.Socket;
import java.security.Principal;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.exolab.jms.net.connector.Authenticator;
import org.exolab.jms.net.connector.ResourceException;
import org.exolab.jms.net.socket.SocketManagedConnection;
import org.exolab.jms.net.socket.SocketRequestInfo;
import org.exolab.jms.net.tcp.TCPSRequestInfo;
import org.exolab.jms.net.uri.URI;
import org.exolab.jms.net.util.SSLHelper;

class TCPSManagedConnection
extends SocketManagedConnection {
    public TCPSManagedConnection(Principal principal, TCPSRequestInfo info) throws ResourceException {
        super(principal, info);
    }

    public TCPSManagedConnection(URI uri, Socket socket, Authenticator authenticator) throws ResourceException {
        super(uri, socket, authenticator);
    }

    protected Socket createSocket(SocketRequestInfo info) throws ResourceException {
        TCPSRequestInfo config = (TCPSRequestInfo)info;
        if (config.getSSLProperties() != null) {
            try {
                SSLHelper.configure(config.getSSLProperties());
            }
            catch (SecurityException exception) {
                throw new ResourceException(exception);
            }
        }
        return super.createSocket(info);
    }

    protected Socket createSocket(String host, int port) throws IOException {
        SocketFactory factory = SSLSocketFactory.getDefault();
        Socket socket = factory.createSocket(host, port);
        socket.setTcpNoDelay(true);
        return socket;
    }
}

