/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.net.tcp;

import org.exolab.jms.net.connector.ResourceException;
import org.exolab.jms.net.socket.SocketRequestInfo;
import org.exolab.jms.net.uri.URI;
import org.exolab.jms.net.util.Properties;
import org.exolab.jms.net.util.SSLProperties;

public class TCPSRequestInfo
extends SocketRequestInfo {
    private SSLProperties _sslProperties = null;
    private boolean _needCientAuth = false;
    private static final String NEED_CLIENT_AUTH = "needClientAuth";

    public TCPSRequestInfo(URI uri) throws ResourceException {
        super(uri);
    }

    public TCPSRequestInfo(URI uri, Properties properties) throws ResourceException {
        super(uri, properties);
        SSLProperties ssl = new SSLProperties(properties);
        if (!ssl.isEmpty()) {
            this.setSSLProperties(ssl);
        }
        this.setNeedClientAuth(properties.getBoolean(NEED_CLIENT_AUTH, this._needCientAuth));
    }

    public SSLProperties getSSLProperties() {
        return this._sslProperties;
    }

    public void setSSLProperties(SSLProperties properties) {
        this._sslProperties = properties;
    }

    public void setNeedClientAuth(boolean required) {
        this._needCientAuth = required;
    }

    public boolean getNeedClientAuth() {
        return this._needCientAuth;
    }

    public void export(Properties properties) {
        super.export(properties);
        SSLProperties ssl = this.getSSLProperties();
        if (ssl != null) {
            ssl.export(properties);
        }
        properties.set(NEED_CLIENT_AUTH, this.getNeedClientAuth());
    }

    public boolean equals(Object other) {
        boolean equal = false;
        if (other instanceof TCPSRequestInfo && super.equals(other)) {
            TCPSRequestInfo info = (TCPSRequestInfo)other;
            if (this._needCientAuth == info._needCientAuth && this.equals(this._sslProperties, info._sslProperties)) {
                equal = true;
            }
        }
        return equal;
    }
}

