/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.net.util;

import java.lang.reflect.Method;
import java.util.ArrayList;

public final class MethodHelper {
    private MethodHelper() {
    }

    public static Method[] getAllInterfaceMethods(Class clazz) {
        int size = 10;
        ArrayList result = new ArrayList(10);
        MethodHelper.getInterfaceMethods(MethodHelper.getAllInterfaces(clazz), result);
        return result.toArray(new Method[0]);
    }

    public static Method[] getInterfaceMethods(Class clazz) {
        int size = 10;
        ArrayList result = new ArrayList(10);
        MethodHelper.getInterfaceMethods(clazz.getInterfaces(), result);
        return result.toArray(new Method[0]);
    }

    public static long getMethodID(Method method) {
        int shift = 32;
        long hash = method.getDeclaringClass().getName().hashCode();
        hash ^= (long)method.getName().hashCode();
        hash ^= (long)method.getReturnType().getName().hashCode();
        Class<?>[] args = method.getParameterTypes();
        int i = 0;
        while (i < args.length) {
            hash ^= (long)args[i].getName().hashCode() << 32;
            ++i;
        }
        return hash;
    }

    private static void getInterfaceMethods(Class[] interfaces, ArrayList result) {
        int i = 0;
        while (i < interfaces.length) {
            Class iface = interfaces[i];
            MethodHelper.getInterfaceMethods(iface.getInterfaces(), result);
            Method[] methods = iface.getMethods();
            int j = 0;
            while (j < methods.length) {
                if (methods[j].getDeclaringClass() == interfaces[i]) {
                    result.add(methods[j]);
                }
                ++j;
            }
            ++i;
        }
    }

    public static Class[] getAllInterfaces(Class clazz) {
        ArrayList result = new ArrayList();
        MethodHelper.getAllInterfaces(clazz, result);
        return result.toArray(new Class[0]);
    }

    private static void getAllInterfaces(Class clazz, ArrayList result) {
        Class<?>[] interfaces = clazz.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            if (!result.contains(interfaces[i])) {
                result.add(interfaces[i]);
            }
            ++i;
        }
        Class superClass = clazz.getSuperclass();
        if (superClass != null) {
            MethodHelper.getAllInterfaces(superClass, result);
        }
    }
}

