/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.net.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public final class SerializationHelper {
    private SerializationHelper() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void write(Class type, Object object, ObjectOutput out) throws IOException {
        if (type.isPrimitive()) {
            if (type == Boolean.TYPE) {
                out.writeBoolean((Boolean)object);
                return;
            } else if (type == Byte.TYPE) {
                out.writeByte(((Byte)object).byteValue());
                return;
            } else if (type == Character.TYPE) {
                out.writeChar(((Character)object).charValue());
                return;
            } else if (type == Short.TYPE) {
                out.writeShort(((Short)object).shortValue());
                return;
            } else if (type == Integer.TYPE) {
                out.writeInt((Integer)object);
                return;
            } else if (type == Long.TYPE) {
                out.writeLong((Long)object);
                return;
            } else if (type == Float.TYPE) {
                out.writeFloat(((Float)object).floatValue());
                return;
            } else {
                if (type != Double.TYPE) throw new IOException("Unsupported primitive type: " + type);
                out.writeDouble((Double)object);
            }
            return;
        } else {
            out.writeObject(object);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object read(Class type, ObjectInput in) throws ClassNotFoundException, IOException {
        if (!type.isPrimitive()) return in.readObject();
        if (type == Boolean.TYPE) {
            return new Boolean(in.readBoolean());
        }
        if (type == Byte.TYPE) {
            return new Byte(in.readByte());
        }
        if (type == Character.TYPE) {
            return new Character(in.readChar());
        }
        if (type == Short.TYPE) {
            return new Short(in.readShort());
        }
        if (type == Integer.TYPE) {
            return new Integer(in.readInt());
        }
        if (type == Long.TYPE) {
            return new Long(in.readLong());
        }
        if (type == Float.TYPE) {
            return new Float(in.readFloat());
        }
        if (type != Double.TYPE) throw new IOException("Unsupported primitive type: " + type);
        return new Double(in.readDouble());
    }
}

