/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.net.vm;

import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.net.connector.Authenticator;
import org.exolab.jms.net.connector.ConnectException;
import org.exolab.jms.net.connector.ManagedConnectionAcceptor;
import org.exolab.jms.net.connector.ManagedConnectionAcceptorListener;
import org.exolab.jms.net.connector.ResourceException;
import org.exolab.jms.net.connector.SecurityException;
import org.exolab.jms.net.connector.URIRequestInfo;
import org.exolab.jms.net.uri.URI;
import org.exolab.jms.net.vm.VMInvoker;
import org.exolab.jms.net.vm.VMManagedConnection;

class VMManagedConnectionAcceptor
implements ManagedConnectionAcceptor {
    private final Authenticator _authenticator;
    private final URI _uri;
    private ManagedConnectionAcceptorListener _listener;
    private static Map _acceptors = new HashMap();
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$net$vm$VMManagedConnectionAcceptor == null ? (class$org$exolab$jms$net$vm$VMManagedConnectionAcceptor = VMManagedConnectionAcceptor.class$("org.exolab.jms.net.vm.VMManagedConnectionAcceptor")) : class$org$exolab$jms$net$vm$VMManagedConnectionAcceptor));
    static /* synthetic */ Class class$org$exolab$jms$net$vm$VMManagedConnectionAcceptor;

    public VMManagedConnectionAcceptor(Authenticator authenticator, URIRequestInfo info) {
        this._authenticator = authenticator;
        this._uri = info.getURI();
    }

    public synchronized void accept(ManagedConnectionAcceptorListener listener) throws ResourceException {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 'listener' is null");
        }
        if (this._listener != null) {
            throw new ResourceException("Acceptor already accepting connections at URI=" + this._uri);
        }
        Map map = _acceptors;
        synchronized (map) {
            if (_acceptors.containsKey(this._uri)) {
                throw new ResourceException("Cannot accept connections on URI=" + this._uri + ". Address in use.");
            }
            _acceptors.put(this._uri, this);
        }
        this._listener = listener;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("VM connector accepting requests at URI=" + this._uri));
        }
    }

    public synchronized void close() {
        if (this._listener != null) {
            Map map = _acceptors;
            synchronized (map) {
                _acceptors.remove(this._uri);
            }
        }
        this._listener = null;
    }

    public URI getURI() {
        return this._uri;
    }

    protected static VMInvoker connect(Principal principal, URIRequestInfo info, VMInvoker client, URI uri) throws ResourceException {
        VMManagedConnectionAcceptor acceptor;
        URI acceptURI = info.getURI();
        Map map = _acceptors;
        synchronized (map) {
            acceptor = (VMManagedConnectionAcceptor)_acceptors.get(acceptURI);
        }
        if (acceptor == null) {
            throw new ConnectException("Connection refused, URI=" + acceptURI);
        }
        return acceptor.accept(principal, info, client, uri);
    }

    protected VMInvoker accept(Principal principal, URIRequestInfo info, VMInvoker client, URI uri) throws ResourceException {
        ManagedConnectionAcceptorListener listener;
        if (!this._authenticator.authenticate(principal)) {
            throw new SecurityException("Failed to authenticate: " + principal);
        }
        VMManagedConnection connection = new VMManagedConnection(principal, info, client, uri);
        VMInvoker invoker = new VMInvoker(connection);
        VMManagedConnectionAcceptor vMManagedConnectionAcceptor = this;
        synchronized (vMManagedConnectionAcceptor) {
            listener = this._listener;
        }
        if (listener == null) {
            throw new ConnectException("Connection refused, URI=" + this._uri);
        }
        listener.accepted(this, connection);
        return invoker;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

