/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.tools.admin;

import java.awt.Component;
import java.sql.Connection;
import java.util.Enumeration;
import javax.swing.JOptionPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.authentication.User;
import org.exolab.jms.config.Configuration;
import org.exolab.jms.config.DatabaseConfiguration;
import org.exolab.jms.persistence.DatabaseService;
import org.exolab.jms.persistence.PersistenceException;
import org.exolab.jms.service.ServiceException;
import org.exolab.jms.tools.admin.AbstractAdminConnection;
import org.exolab.jms.tools.admin.OfflineConnectionException;

public class OfflineConnection
extends AbstractAdminConnection {
    private Component _parent;
    private DatabaseService _database;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$tools$admin$OfflineConnection == null ? (class$org$exolab$jms$tools$admin$OfflineConnection = OfflineConnection.class$("org.exolab.jms.tools.admin.OfflineConnection")) : class$org$exolab$jms$tools$admin$OfflineConnection));
    static /* synthetic */ Class class$org$exolab$jms$tools$admin$OfflineConnection;

    public OfflineConnection(Component parent, Configuration config) throws OfflineConnectionException {
        block4: {
            try {
                if (AbstractAdminConnection._instance == null) {
                    this._parent = parent;
                    this._database = new DatabaseService(config);
                    this._database.start();
                    DatabaseConfiguration dbconfig = config.getDatabaseConfiguration();
                    if (dbconfig.getRdbmsDatabaseConfiguration() != null) {
                        this._database.getAdapter();
                        AbstractAdminConnection._instance = this;
                    }
                    break block4;
                }
                throw new OfflineConnectionException("Already connected");
            }
            catch (Exception err) {
                _log.error((Object)err.getMessage(), (Throwable)err);
                throw new OfflineConnectionException("Database Error: " + err.getMessage());
            }
        }
    }

    public void close() {
        try {
            this._database.stop();
        }
        catch (ServiceException exception) {
            _log.error((Object)exception, (Throwable)exception);
        }
        AbstractAdminConnection._instance = null;
    }

    public boolean addDurableConsumer(String topic, String name) {
        boolean result = false;
        try {
            this._database.begin();
            Connection connection = this._database.getConnection();
            this._database.getAdapter().addDurableConsumer(connection, topic, name);
            this._database.commit();
            result = true;
        }
        catch (PersistenceException exception) {
            this.error("Failed to add durable consumer=" + name + " for topic=" + topic, exception);
        }
        return result;
    }

    public boolean removeDurableConsumer(String name) {
        boolean result = false;
        try {
            this._database.begin();
            Connection connection = this._database.getConnection();
            this._database.getAdapter().removeDurableConsumer(connection, name);
            this._database.commit();
            result = true;
        }
        catch (PersistenceException exception) {
            this.error("Failed to remove durable consumer=" + name, exception);
        }
        return result;
    }

    public boolean unregisterConsumer(String name) {
        return false;
    }

    public boolean isConnected(String name) {
        return false;
    }

    public Enumeration getAllDestinations() {
        Enumeration result = null;
        try {
            this._database.begin();
            Connection connection = this._database.getConnection();
            result = this._database.getAdapter().getAllDestinations(connection);
            this._database.commit();
        }
        catch (PersistenceException exception) {
            this.error("Failed to get destinations", exception);
        }
        return result;
    }

    public boolean addDestination(String destination, boolean isQueue) {
        boolean success = false;
        try {
            this._database.begin();
            Connection connection = this._database.getConnection();
            this._database.getAdapter().addDestination(connection, destination, isQueue);
            this._database.commit();
            success = true;
        }
        catch (PersistenceException exception) {
            this.error("Failed to add destination=" + destination, exception);
        }
        return success;
    }

    public int getDurableConsumerMessageCount(String topic, String name) {
        int count = -1;
        try {
            this._database.begin();
            Connection connection = this._database.getConnection();
            count = this._database.getAdapter().getDurableConsumerMessageCount(connection, topic, name);
            this._database.commit();
        }
        catch (PersistenceException exception) {
            this.error("Failed to get message count for topic=" + topic + ", name=" + name, exception);
        }
        return count;
    }

    public int getQueueMessageCount(String queue) {
        int count = -1;
        try {
            this._database.begin();
            Connection connection = this._database.getConnection();
            count = this._database.getAdapter().getQueueMessageCount(connection, queue);
            this._database.commit();
        }
        catch (PersistenceException exception) {
            this.error("Failed to get message count for queue=" + queue, exception);
        }
        return count;
    }

    public boolean durableConsumerExists(String name) {
        boolean result = false;
        try {
            this._database.begin();
            Connection connection = this._database.getConnection();
            result = this._database.getAdapter().durableConsumerExists(connection, name);
            this._database.commit();
        }
        catch (PersistenceException exception) {
            this.error("Failed to determine if consumer exists: " + name, exception);
        }
        return result;
    }

    public Enumeration getDurableConsumers(String topic) {
        Enumeration result = null;
        try {
            this._database.begin();
            Connection connection = this._database.getConnection();
            result = this._database.getAdapter().getDurableConsumers(connection, topic);
            this._database.commit();
        }
        catch (PersistenceException exception) {
            this.error("Failed to retrieve durable consumers", exception);
        }
        return result;
    }

    public boolean removeDestination(String destination) {
        boolean result = false;
        try {
            this._database.begin();
            Connection connection = this._database.getConnection();
            this._database.getAdapter().removeDestination(connection, destination);
            this._database.commit();
            result = true;
        }
        catch (PersistenceException exception) {
            this.error("Failed to remove destination=" + destination, exception);
        }
        return result;
    }

    public int purgeMessages() {
        return this._database.getAdapter().purgeMessages();
    }

    public void stopServer() {
        JOptionPane.showMessageDialog(this._parent, "Not available in offline mode", "Shutdown Error", 0);
    }

    public boolean addUser(String username, String password) {
        boolean success = false;
        try {
            this._database.begin();
            Connection connection = this._database.getConnection();
            this._database.getAdapter().addUser(connection, new User(username, password));
            this._database.commit();
            success = true;
        }
        catch (PersistenceException exception) {
            this.error("Failed to add user=" + username, exception);
        }
        return success;
    }

    public boolean changePassword(String username, String password) {
        boolean success = false;
        try {
            this._database.begin();
            Connection connection = this._database.getConnection();
            this._database.getAdapter().updateUser(connection, new User(username, password));
            this._database.commit();
            success = true;
        }
        catch (PersistenceException exception) {
            this.error("Failed to change password for user=" + username, exception);
        }
        return success;
    }

    public boolean removeUser(String username) {
        boolean result = false;
        try {
            this._database.begin();
            Connection connection = this._database.getConnection();
            this._database.getAdapter().removeUser(connection, new User(username, null));
            this._database.commit();
            result = true;
        }
        catch (PersistenceException exception) {
            this.error("Failed to remove user=" + username, exception);
        }
        return result;
    }

    public Enumeration getAllUsers() {
        Enumeration result = null;
        try {
            this._database.begin();
            Connection connection = this._database.getConnection();
            result = this._database.getAdapter().getAllUsers(connection);
            this._database.commit();
        }
        catch (PersistenceException exception) {
            this.rollback();
        }
        return result;
    }

    private void error(String message, PersistenceException exception) {
        _log.error((Object)message, (Throwable)exception);
        this.rollback();
    }

    private void rollback() {
        try {
            this._database.rollback();
        }
        catch (PersistenceException exception) {
            _log.warn((Object)exception, (Throwable)exception);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

