/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.tools.admin;

import java.awt.Component;
import java.util.Enumeration;
import java.util.Vector;
import javax.jms.JMSException;
import javax.swing.JOptionPane;
import org.exolab.jms.administration.AdminConnectionFactory;
import org.exolab.jms.administration.JmsAdminServerIfc;
import org.exolab.jms.config.ConfigHelper;
import org.exolab.jms.config.Configuration;
import org.exolab.jms.config.Connector;
import org.exolab.jms.config.SecurityConfiguration;
import org.exolab.jms.config.types.SchemeType;
import org.exolab.jms.tools.admin.AbstractAdminConnection;
import org.exolab.jms.tools.admin.CreateLogonDialog;
import org.exolab.jms.tools.admin.OnlineConnectionException;

public class OnlineConnection
extends AbstractAdminConnection {
    private JmsAdminServerIfc _admin = null;
    private Component _parent;

    public OnlineConnection(Component parent, Configuration config) throws OnlineConnectionException {
        String username = "anonymous";
        String password = "anonymous";
        try {
            String url;
            if (AbstractAdminConnection._instance == null) {
                Connector connector = config.getConnectors().getConnector(0);
                SchemeType scheme = connector.getScheme();
                url = ConfigHelper.getAdminURL((SchemeType)scheme, (Configuration)config);
                SecurityConfiguration security = config.getSecurityConfiguration();
                if (security.getSecurityEnabled()) {
                    CreateLogonDialog.instance().displayCreateLogon();
                    if (CreateLogonDialog.instance().isConfirmed()) {
                        username = CreateLogonDialog.instance().getName();
                        password = CreateLogonDialog.instance().getPassword();
                    }
                }
            } else {
                throw new OnlineConnectionException("Already connected");
            }
            this._admin = AdminConnectionFactory.create((String)url, (String)username, (String)password);
            this._parent = parent;
            AbstractAdminConnection._instance = this;
        }
        catch (Exception err) {
            throw new OnlineConnectionException("Failed to connect: " + err.toString());
        }
    }

    public OnlineConnection(String username, String password, Configuration config) throws OnlineConnectionException {
        try {
            if (AbstractAdminConnection._instance != null) {
                throw new OnlineConnectionException("Already connected");
            }
            Connector connector = config.getConnectors().getConnector(0);
            SchemeType scheme = connector.getScheme();
            String url = ConfigHelper.getAdminURL((SchemeType)scheme, (Configuration)config);
            this._admin = AdminConnectionFactory.create((String)url, (String)username, (String)password);
            AbstractAdminConnection._instance = this;
        }
        catch (Exception err) {
            throw new OnlineConnectionException("Failed to connect: " + err.toString());
        }
    }

    private void displayError(Exception err, String st) {
        JOptionPane.showMessageDialog(this._parent, st + "\n" + err, st, 0);
    }

    public void close() {
        this._admin.close();
        AbstractAdminConnection._instance = null;
        this._admin = null;
    }

    public boolean addDurableConsumer(String topic, String name) {
        try {
            return this._admin.addDurableConsumer(topic, name);
        }
        catch (JMSException error) {
            if (error.getLinkedException() != null) {
                error.getLinkedException().printStackTrace();
            }
            this.displayError((Exception)((Object)error), "Failed to add consumer");
            return false;
        }
        catch (Exception err) {
            this.displayError(err, "Failed to add consumer " + name);
            return false;
        }
    }

    public boolean removeDurableConsumer(String name) {
        try {
            return this._admin.removeDurableConsumer(name);
        }
        catch (Exception err) {
            this.displayError(err, "Failed to remove consumer " + name);
            return false;
        }
    }

    public boolean unregisterConsumer(String name) {
        try {
            return this._admin.unregisterConsumer(name);
        }
        catch (Exception err) {
            this.displayError(err, "Failed to De-Activate consumer " + name);
            return false;
        }
    }

    public boolean isConnected(String name) {
        try {
            return this._admin.isConnected(name);
        }
        catch (Exception err) {
            return false;
        }
    }

    public Enumeration getAllDestinations() {
        try {
            Vector v = this._admin.getAllDestinations();
            Enumeration e = null;
            if (v != null) {
                e = v.elements();
            }
            return e;
        }
        catch (Exception err) {
            this.displayError(err, "Failed to getAllQueueTopics");
            return null;
        }
    }

    public boolean addDestination(String destination, boolean isQueue) {
        try {
            return this._admin.addDestination(destination, new Boolean(isQueue));
        }
        catch (Exception err) {
            this.displayError(err, "Failed to add destination");
            return false;
        }
    }

    public int getDurableConsumerMessageCount(String topic, String name) {
        try {
            return this._admin.getDurableConsumerMessageCount(topic, name);
        }
        catch (Exception err) {
            this.displayError(err, "Failed in getDurableConsumerMessageCount");
            return -1;
        }
    }

    public int getQueueMessageCount(String queue) {
        try {
            return this._admin.getQueueMessageCount(queue);
        }
        catch (Exception err) {
            this.displayError(err, "Failed in getQueueMessageCount");
            return -1;
        }
    }

    public boolean durableConsumerExists(String name) {
        try {
            return this._admin.durableConsumerExists(name);
        }
        catch (Exception err) {
            this.displayError(err, "Failed in durableConsumerExists");
            return false;
        }
    }

    public Enumeration getDurableConsumers(String topic) {
        try {
            Vector v = this._admin.getDurableConsumers(topic);
            Enumeration e = null;
            if (v != null) {
                e = v.elements();
            }
            return e;
        }
        catch (Exception err) {
            this.displayError(err, "Failed in getDurableConsumers");
            return null;
        }
    }

    public boolean removeDestination(String destination) {
        try {
            return this._admin.removeDestination(destination);
        }
        catch (Exception err) {
            this.displayError(err, "Failed to destroy destination");
            return false;
        }
    }

    public int purgeMessages() {
        int result = -1;
        try {
            result = this._admin.purgeMessages();
        }
        catch (Exception err) {
            this.displayError(err, "Failed to purge messages from database");
        }
        return result;
    }

    public void stopServer() {
        try {
            if (this._admin == null) {
                JOptionPane.showMessageDialog(this._parent, "Must connect with online mode \nto shutdown server", "Shutdown Error", 0);
            } else {
                this._admin.stopServer();
                AbstractAdminConnection._instance = null;
                this._admin = null;
            }
        }
        catch (Exception err) {
            this.displayError(err, "Failed to Stop server");
        }
    }

    public boolean addUser(String username, String password) {
        try {
            return this._admin.addUser(username, password);
        }
        catch (JMSException error) {
            if (error.getLinkedException() != null) {
                error.getLinkedException().printStackTrace();
            }
            this.displayError((Exception)((Object)error), "Failed to add user");
            return false;
        }
        catch (Exception err) {
            this.displayError(err, "Failed to add user " + username);
            return false;
        }
    }

    public boolean changePassword(String username, String password) {
        try {
            return this._admin.changePassword(username, password);
        }
        catch (JMSException error) {
            if (error.getLinkedException() != null) {
                error.getLinkedException().printStackTrace();
            }
            this.displayError((Exception)((Object)error), "Failed to change password");
            return false;
        }
        catch (Exception err) {
            this.displayError(err, "Failed to change password for user " + username);
            return false;
        }
    }

    public boolean removeUser(String username) {
        try {
            return this._admin.removeUser(username);
        }
        catch (JMSException error) {
            if (error.getLinkedException() != null) {
                error.getLinkedException().printStackTrace();
            }
            this.displayError((Exception)((Object)error), "Failed to remove user");
            return false;
        }
        catch (Exception err) {
            this.displayError(err, "Failed to remove user " + username);
            return false;
        }
    }

    public Enumeration getAllUsers() {
        try {
            Vector v = this._admin.getAllUsers();
            Enumeration e = null;
            if (v != null) {
                e = v.elements();
            }
            return e;
        }
        catch (Exception err) {
            this.displayError(err, "Failed to getAllUsers");
            return null;
        }
    }
}

