/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.tools.admin;

import java.awt.Rectangle;
import java.text.SimpleDateFormat;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.exolab.jms.tools.admin.OpenJMSNode;

public abstract class OpenJMSDestination
extends DefaultMutableTreeNode
implements OpenJMSNode {
    protected String destinationName_;
    protected boolean isLeaf_;
    protected boolean isExplored_ = false;
    protected JPopupMenu commands_ = null;
    protected boolean commandsCreated_ = false;
    protected static SimpleDateFormat dateFormat_;
    protected static JTree tree_;

    public OpenJMSDestination(String destinationName, JTree tree) {
        this.destinationName_ = destinationName;
        this.isLeaf_ = false;
        if (!this.commandsCreated_) {
            tree_ = tree;
            this.createCommands();
            this.commandsCreated_ = true;
            dateFormat_ = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
            dateFormat_.setLenient(false);
        }
    }

    protected abstract void createCommands();

    public boolean getAllowsChildren() {
        return true;
    }

    public boolean isLeaf() {
        return this.isLeaf_;
    }

    public void displayCommands(Rectangle loc) {
        double x = loc.getX();
        double y = loc.getY();
        this.commands_.show(tree_, (int)x, (int)(y += loc.getHeight()));
    }

    public String toString() {
        return this.destinationName_;
    }

    protected void refresh() {
        DefaultTreeModel model = (DefaultTreeModel)tree_.getModel();
        model.nodeStructureChanged(this);
    }

    protected static OpenJMSDestination getInstanceSelected() {
        Object loc = tree_.getLastSelectedPathComponent();
        return (OpenJMSDestination)loc;
    }

    public abstract void update();

    static {
        tree_ = null;
    }
}

