/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.tools.admin;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import org.exolab.jms.tools.admin.AbstractAdminConnection;
import org.exolab.jms.tools.admin.ChangePasswordDialog;
import org.exolab.jms.tools.admin.OpenJMSObject;
import org.exolab.jms.tools.admin.QueryDialog;

public class OpenJMSUser
extends OpenJMSObject {
    public OpenJMSUser(String name, JTree tree) {
        super(name, tree);
    }

    public void update() {
    }

    protected void createCommands() {
        this._commands = new JPopupMenu();
        JMenuItem m = new JMenuItem("Delete user");
        m.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OpenJMSUser.deleteUser();
            }
        });
        this._commands.add(m);
        m = new JMenuItem("Change password");
        m.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OpenJMSUser.changePassword();
            }
        });
        this._commands.add(m);
    }

    private static void changePassword() {
        OpenJMSUser This = (OpenJMSUser)OpenJMSObject.getInstanceSelected();
        ChangePasswordDialog.instance().displayChangePassword(This._name);
        if (ChangePasswordDialog.instance().isConfirmed()) {
            if (AbstractAdminConnection.instance().changePassword(This._name, ChangePasswordDialog.instance().getPassword())) {
                This.refresh();
            } else {
                JOptionPane.showMessageDialog(OpenJMSObject._tree, "User already exists", "Create Error", 0);
            }
        }
    }

    private static void deleteUser() {
        OpenJMSUser This = (OpenJMSUser)OpenJMSObject.getInstanceSelected();
        QueryDialog.instance().display("Are you sure you want to delete \nselected User: " + This._name);
        if (QueryDialog.instance().isConfirmed()) {
            if (AbstractAdminConnection.instance().removeUser(This._name)) {
                This.removeFromParent();
                This.refresh();
            } else {
                JOptionPane.showMessageDialog(OpenJMSObject._tree, "Failed to destroy User", "Destroy User Error", 0);
            }
        }
    }
}

