/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.tools.db;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.exolab.jms.persistence.PersistenceException;
import org.exolab.jms.persistence.SQLHelper;
import org.exolab.jms.tools.db.Attribute;
import org.exolab.jms.tools.db.InvalidTypeException;
import org.exolab.jms.tools.db.Table;
import org.exolab.jms.tools.db.Type;
import org.exolab.jms.tools.db.TypeMapper;
import org.exolab.jms.tools.db.TypeSet;

public class SchemaBrowser {
    private final Connection _connection;
    private final TypeSet _types;
    private final TypeMapper _mapper;

    public SchemaBrowser(Connection connection) throws PersistenceException {
        this._connection = connection;
        this._types = new TypeSet(this._connection);
        this._mapper = new TypeMapper(this._types);
    }

    public Table getTable(String name) throws PersistenceException {
        Table result = new Table();
        result.setName(name);
        PreparedStatement select = null;
        try {
            try {
                select = this._connection.prepareStatement("select * from " + name + " where 1 = 0");
                ResultSet set = select.executeQuery();
                ResultSetMetaData metaData = set.getMetaData();
                int i = 1;
                while (i <= metaData.getColumnCount()) {
                    String columnName = metaData.getColumnName(i);
                    int dataType = metaData.getColumnType(i);
                    long precision = metaData.getPrecision(i);
                    int nullable = metaData.isNullable(i);
                    String typeName = metaData.getColumnTypeName(i);
                    Type type = this._mapper.getType(dataType, precision);
                    if (type == null && (type = this._types.getNearestType(dataType, precision)) == null) {
                        throw new InvalidTypeException("JDBC driver error. Type=" + dataType + ", precision=" + precision + "(SQL type=" + typeName + ") isn't supported by " + "Connection.getMetaData().getTypeInfo(), " + "but is referred to by " + "Connection.getMetaData().getColumns()");
                    }
                    Attribute attribute = new Attribute();
                    attribute.setName(columnName);
                    attribute.setType(type.getSymbolicType());
                    if (nullable == 0) {
                        attribute.setNotNull(true);
                    } else {
                        attribute.setNotNull(false);
                    }
                    result.addAttribute(attribute);
                    ++i;
                }
            }
            catch (SQLException exception) {
                throw new PersistenceException("Failed to determine the schema of table=" + name, (Throwable)exception);
            }
            Object var16_15 = null;
        }
        catch (Throwable throwable) {
            Object var16_16 = null;
            SQLHelper.close(select);
            throw throwable;
        }
        SQLHelper.close((Statement)select);
        return result;
    }

    public Type getType(Attribute attribute) throws PersistenceException {
        Type result = null;
        Type type = Type.getType(attribute.getType());
        Type map = this._mapper.getType(type.getType(), type.getPrecision());
        if (map == null) {
            throw new PersistenceException("Database does not support type=" + attribute.getType());
        }
        if (type.getType() != map.getType()) {
            result = map;
        } else {
            boolean parameters = type.getParameters();
            long precision = type.getPrecision();
            if (precision <= map.getPrecision()) {
                if (precision == -1L) {
                    precision = map.getPrecision();
                    parameters = map.getParameters();
                }
                result = new Type(map.getType(), map.getName(), precision, parameters);
            } else {
                throw new PersistenceException(attribute.getName() + type + " exceeds precision for " + map + " precision=" + map.getPrecision());
            }
        }
        return result;
    }

    public boolean getTableExists(String table) throws PersistenceException {
        boolean result = false;
        String name = table;
        ResultSet set = null;
        try {
            block5: {
                try {
                    DatabaseMetaData metaData = this._connection.getMetaData();
                    if (metaData.storesUpperCaseIdentifiers()) {
                        name = name.toUpperCase();
                    }
                    if (!(set = metaData.getTables(this._connection.getCatalog(), null, name, null)).next()) break block5;
                    result = true;
                }
                catch (SQLException exception) {
                    throw new PersistenceException("Failed to determine if table=" + table + " exists", (Throwable)exception);
                }
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            SQLHelper.close(set);
            throw throwable;
        }
        SQLHelper.close((ResultSet)set);
        return result;
    }
}

