/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.tools.db;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.exolab.jms.persistence.PersistenceException;
import org.exolab.jms.persistence.SQLHelper;
import org.exolab.jms.tools.db.Attribute;
import org.exolab.jms.tools.db.Database;
import org.exolab.jms.tools.db.Table;

public class SchemaHelper {
    private static final String SCHEMA = "/org/exolab/jms/tools/db/schema.xml";
    static /* synthetic */ Class class$org$exolab$jms$tools$db$SchemaHelper;

    public static String getSchemaVersion(Connection connection) throws PersistenceException {
        String version = null;
        PreparedStatement query = null;
        ResultSet result = null;
        try {
            block4: {
                try {
                    query = connection.prepareStatement("select version from system_data where id = 1");
                    result = query.executeQuery();
                    if (!result.next()) break block4;
                    version = result.getString(1);
                }
                catch (SQLException exception) {
                    throw new PersistenceException("Failed to get the schema version", (Throwable)exception);
                }
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            SQLHelper.close(result);
            SQLHelper.close((Statement)query);
            throw throwable;
        }
        SQLHelper.close((ResultSet)result);
        SQLHelper.close((Statement)query);
        return version;
    }

    public static void setVersion(Connection connection, String version) throws PersistenceException {
        PreparedStatement update = null;
        try {
            try {
                update = connection.prepareStatement("update system_data set version=? where id = 1");
                update.setString(1, version);
                if (update.executeUpdate() != 1) {
                    throw new PersistenceException("Failed to update system_data.version");
                }
                Object var5_3 = null;
            }
            catch (SQLException exception) {
                throw new PersistenceException("Failed to update system_data.version", (Throwable)exception);
            }
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            SQLHelper.close((Statement)update);
            throw throwable;
        }
        SQLHelper.close((Statement)update);
    }

    public static Table getTable(Database schema, String name) {
        Table result = null;
        Table[] tables = schema.getTable();
        int i = 0;
        while (i < tables.length) {
            if (tables[i].getName().equalsIgnoreCase(name)) {
                result = tables[i];
                break;
            }
            ++i;
        }
        return result;
    }

    public static Attribute getAttribute(Table table, String name) {
        Attribute result = null;
        Attribute[] attributes = table.getAttribute();
        int i = 0;
        while (i < attributes.length) {
            if (attributes[i].getName().equalsIgnoreCase(name)) {
                result = attributes[i];
                break;
            }
            ++i;
        }
        return result;
    }

    public static Database getSchema() throws PersistenceException {
        return SchemaHelper.getSchemaFromResource(SCHEMA);
    }

    public static Database getSchemaFromResource(String path) throws PersistenceException {
        Database schema = null;
        InputStream stream = (class$org$exolab$jms$tools$db$SchemaHelper == null ? (class$org$exolab$jms$tools$db$SchemaHelper = SchemaHelper.class$("org.exolab.jms.tools.db.SchemaHelper")) : class$org$exolab$jms$tools$db$SchemaHelper).getResourceAsStream(path);
        if (stream == null) {
            throw new PersistenceException("Cannot locate resource: " + path);
        }
        try {
            schema = Database.unmarshal(new InputStreamReader(stream));
        }
        catch (MarshalException exception) {
            throw new PersistenceException(exception.getMessage());
        }
        catch (ValidationException exception) {
            throw new PersistenceException(exception.getMessage());
        }
        return schema;
    }

    public static Database getSchema(String path) throws PersistenceException {
        Database schema = null;
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(path);
        }
        catch (FileNotFoundException exception) {
            throw new PersistenceException(exception.getMessage(), (Throwable)exception);
        }
        try {
            schema = Database.unmarshal(new InputStreamReader(stream));
        }
        catch (MarshalException exception) {
            throw new PersistenceException(exception.getMessage());
        }
        catch (ValidationException exception) {
            throw new PersistenceException(exception.getMessage());
        }
        return schema;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

