/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.tools.migration;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.derby.jdbc.EmbeddedDataSource;
import org.exolab.jms.config.Configuration;
import org.exolab.jms.config.ConfigurationReader;
import org.exolab.jms.persistence.DatabaseService;
import org.exolab.jms.persistence.PersistenceException;
import org.exolab.jms.service.ServiceException;
import org.exolab.jms.tools.db.Database;
import org.exolab.jms.tools.db.RDBMSTool;
import org.exolab.jms.tools.db.SchemaHelper;
import org.exolab.jms.tools.migration.Store;
import org.exolab.jms.tools.migration.StoreIterator;
import org.exolab.jms.tools.migration.master.MasterConsumerStore;
import org.exolab.jms.tools.migration.master.MasterDestinationStore;
import org.exolab.jms.tools.migration.master.MasterMessageStore;
import org.exolab.jms.tools.migration.master.MasterUserStore;
import org.exolab.jms.tools.migration.proxy.ConsumerStore;
import org.exolab.jms.tools.migration.proxy.DestinationStore;
import org.exolab.jms.tools.migration.proxy.MessageStore;
import org.exolab.jms.tools.migration.proxy.PropertyStore;
import org.exolab.jms.tools.migration.proxy.UserStore;
import org.exolab.jms.tools.migration.proxy.VersionInfo;
import org.exolab.jms.util.CommandLine;

public class Importer {
    private final DatabaseService _database;
    private final EmbeddedDataSource _dataSource;
    private final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$tools$migration$Importer == null ? (class$org$exolab$jms$tools$migration$Importer = Importer.class$("org.exolab.jms.tools.migration.Importer")) : class$org$exolab$jms$tools$migration$Importer));
    static /* synthetic */ Class class$org$exolab$jms$tools$migration$Importer;

    public Importer(Configuration config, String database, boolean delete) throws PersistenceException {
        if (config == null) {
            throw new IllegalArgumentException("Argument 'config' is null");
        }
        if (database == null) {
            throw new IllegalArgumentException("Argument 'database' is null");
        }
        this._database = new DatabaseService(config);
        this._dataSource = new EmbeddedDataSource();
        this._dataSource.setDatabaseName(database);
        this._dataSource.setCreateDatabase("create");
        this.init(config, delete);
    }

    public void apply() throws JMSException, PersistenceException, ServiceException {
        Connection source;
        try {
            source = this._dataSource.getConnection();
        }
        catch (SQLException exception) {
            throw new PersistenceException("Failed to get connection to source database", (Throwable)exception);
        }
        this._database.start();
        MasterDestinationStore masterDestinations = new MasterDestinationStore(this._database);
        MasterMessageStore masterMessages = new MasterMessageStore(this._database);
        MasterConsumerStore masterConsumers = new MasterConsumerStore(this._database);
        MasterUserStore masterUsers = new MasterUserStore(this._database);
        PropertyStore properties = new PropertyStore(source);
        VersionInfo info = new VersionInfo(properties);
        String schemaVersion = info.getProxySchemaVersion();
        if (schemaVersion == null || !schemaVersion.equals("1.0")) {
            throw new PersistenceException("Cannot import data: unsupported schema version: " + schemaVersion);
        }
        Date created = new Date(info.getCreationTimestamp());
        this._log.info((Object)("Importing data created on " + created + " by OpenJMS " + info.getOpenJMSVersion()));
        DestinationStore destinations = new DestinationStore(source);
        ConsumerStore consumers = new ConsumerStore(destinations, source);
        MessageStore messages = new MessageStore(destinations, source);
        UserStore users = new UserStore(source);
        this._log.info((Object)"Importing destinations...");
        this.apply(destinations, masterDestinations);
        this._log.info((Object)("Imported " + masterDestinations.size() + " destinations"));
        this._log.info((Object)"Importing messages...");
        this.apply(messages, masterMessages);
        this._log.info((Object)("Imported " + masterMessages.size() + " messages"));
        this._log.info((Object)"Importing consumers...");
        this.apply(consumers, new MasterConsumerStore(this._database));
        this._log.info((Object)("Imported " + masterConsumers.size() + " consumers"));
        this._log.info((Object)"Importing users...");
        this.apply(users, new MasterUserStore(this._database));
        this._log.info((Object)("Imported " + masterUsers.size() + " users"));
        try {
            source.close();
        }
        catch (SQLException exception) {
            throw new PersistenceException("Failed to close source", (Throwable)exception);
        }
        this._database.stop();
        this._dataSource.setShutdownDatabase("shutdown");
        this._log.info((Object)"Import complete");
    }

    public static void main(String[] args) {
        CommandLine commands = new CommandLine(args);
        String path = commands.value("config");
        if (path == null) {
            Importer.usage();
            System.exit(1);
        } else {
            try {
                Configuration config = ConfigurationReader.read((String)path);
                String database = commands.value("db");
                if (database == null) {
                    database = "openjms_migdb";
                }
                boolean delete = commands.exists("delete");
                Importer importer = new Importer(config, database, delete);
                importer.apply();
                System.exit(0);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.exit(1);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void init(Configuration config, boolean delete) throws PersistenceException {
        RDBMSTool tool = new RDBMSTool(config);
        Database schema = SchemaHelper.getSchema();
        try {
            if (tool.hasTables(schema.getTable())) {
                if (!delete) throw new PersistenceException("Cannot import data: master database already exists but delete not specified");
                tool.delete(schema);
            } else {
                tool.create(schema);
            }
            Object var6_5 = null;
            tool.close();
            return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            tool.close();
            throw throwable;
        }
    }

    private void apply(Store source, Store target) throws JMSException, PersistenceException {
        StoreIterator iterator = source.exportCollection();
        target.importCollection(iterator);
    }

    private static void usage() {
        System.err.println("usage: " + (class$org$exolab$jms$tools$migration$Importer == null ? (class$org$exolab$jms$tools$migration$Importer = Importer.class$("org.exolab.jms.tools.migration.Importer")) : class$org$exolab$jms$tools$migration$Importer).getName() + " <arguments> [options]\n" + "arguments:\n" + "  -config <path>  specifies the path to an OpenJMS " + "configuration file\n" + "  -import <path>  specifies the path to import data from\n");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

