/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.tools.migration.master;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.jms.JMSException;
import org.exolab.jms.client.JmsDestination;
import org.exolab.jms.client.JmsQueue;
import org.exolab.jms.persistence.DatabaseService;
import org.exolab.jms.persistence.PersistenceException;
import org.exolab.jms.tools.migration.IteratorAdapter;
import org.exolab.jms.tools.migration.Store;
import org.exolab.jms.tools.migration.StoreIterator;

public class MasterDestinationStore
implements Store {
    private DatabaseService _database;

    public MasterDestinationStore(DatabaseService database) {
        this._database = database;
    }

    public StoreIterator exportCollection() throws JMSException, PersistenceException {
        List destinations = this.getDestinatiuons();
        return new IteratorAdapter(destinations.iterator());
    }

    public void importCollection(StoreIterator iterator) throws JMSException, PersistenceException {
        Connection connection = this._database.getConnection();
        while (iterator.hasNext()) {
            JmsDestination destination = (JmsDestination)iterator.next();
            String name = destination.getName();
            boolean queue = false;
            if (destination instanceof JmsQueue) {
                queue = true;
            }
            this._database.getAdapter().addDestination(connection, name, queue);
        }
        this._database.commit();
    }

    public int size() throws PersistenceException {
        return this.getDestinatiuons().size();
    }

    private List getDestinatiuons() throws PersistenceException {
        ArrayList result = new ArrayList();
        Connection connection = this._database.getConnection();
        Enumeration destinations = this._database.getAdapter().getAllDestinations(connection);
        while (destinations.hasMoreElements()) {
            result.add(destinations.nextElement());
        }
        this._database.commit();
        return result;
    }
}

