/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.tools.migration.master;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jms.JMSException;
import org.exolab.jms.message.MessageImpl;
import org.exolab.jms.persistence.DatabaseService;
import org.exolab.jms.persistence.PersistenceException;
import org.exolab.jms.persistence.SQLHelper;
import org.exolab.jms.tools.migration.Store;
import org.exolab.jms.tools.migration.StoreIterator;

public class MasterMessageStore
implements Store {
    private DatabaseService _database;

    public MasterMessageStore(DatabaseService database) {
        this._database = database;
    }

    public StoreIterator exportCollection() throws JMSException, PersistenceException {
        List ids = this.getMessageIds();
        return new MessageIterator(ids);
    }

    public void importCollection(StoreIterator iterator) throws JMSException, PersistenceException {
        Connection connection = this._database.getConnection();
        while (iterator.hasNext()) {
            MessageImpl message = (MessageImpl)iterator.next();
            this._database.getAdapter().addMessage(connection, message);
        }
        this._database.commit();
    }

    public int size() throws PersistenceException {
        return this.getMessageIds().size();
    }

    private List getMessageIds() throws PersistenceException {
        ArrayList<String> result = new ArrayList<String>(1000);
        String query = "select messageId from messages order by createTime";
        Connection connection = this._database.getConnection();
        PreparedStatement select = null;
        ResultSet set = null;
        try {
            try {
                select = connection.prepareStatement("select messageId from messages order by createTime");
                set = select.executeQuery();
                while (set.next()) {
                    result.add(set.getString(1));
                }
            }
            catch (SQLException exception) {
                throw new PersistenceException("Failed to execute query: select messageId from messages order by createTime", (Throwable)exception);
            }
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            SQLHelper.close(set);
            SQLHelper.close((Statement)select);
            throw throwable;
        }
        SQLHelper.close((ResultSet)set);
        SQLHelper.close((Statement)select);
        this._database.commit();
        return result;
    }

    private class MessageIterator
    implements StoreIterator {
        private final Iterator _iterator;

        public MessageIterator(List ids) {
            this._iterator = ids.iterator();
        }

        public boolean hasNext() {
            return this._iterator.hasNext();
        }

        public Object next() throws PersistenceException {
            MessageImpl result = null;
            String id = (String)this._iterator.next();
            Connection connection = MasterMessageStore.this._database.getConnection();
            result = MasterMessageStore.this._database.getAdapter().getMessage(connection, id);
            MasterMessageStore.this._database.commit();
            return result;
        }
    }
}

