/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.tools.migration.proxy;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import org.exolab.jms.client.JmsDestination;
import org.exolab.jms.persistence.PersistenceException;
import org.exolab.jms.persistence.SQLHelper;
import org.exolab.jms.tools.migration.proxy.DBConstants;
import org.exolab.jms.tools.migration.proxy.DestinationStore;
import org.exolab.jms.tools.migration.proxy.MessageHandler;

abstract class AbstractMessageHandler
implements MessageHandler,
DBConstants {
    private final DestinationStore _destinations;
    private Connection _connection;

    public AbstractMessageHandler(DestinationStore destinations, Connection connection) {
        this._destinations = destinations;
        this._connection = connection;
    }

    public void add(Message message) throws JMSException, PersistenceException {
        this.add(message, this.getType());
    }

    public Message get(String messageId) throws JMSException, PersistenceException {
        Message message = this.newMessage();
        this.get(messageId, message);
        return message;
    }

    protected abstract String getType();

    protected abstract Message newMessage() throws JMSException;

    protected abstract void setBody(Object var1, Message var2) throws JMSException, PersistenceException;

    protected abstract Object getBody(Message var1) throws JMSException;

    protected void get(String messageId, Message message) throws JMSException, PersistenceException {
        PreparedStatement select = null;
        ResultSet set = null;
        try {
            try {
                Object body;
                select = this._connection.prepareStatement("select * from openjms_pmsg where message_id = ?");
                select.setString(1, messageId);
                set = select.executeQuery();
                if (!set.next()) {
                    throw new PersistenceException("Message not found, JMSMessageID=" + messageId);
                }
                String correlationId = set.getString("correlation_id");
                int deliveryMode = set.getInt("delivery_mode");
                long destinationId = set.getLong("destination_id");
                long expiration = set.getLong("expiration");
                int priority = set.getInt("priority");
                boolean redelivered = set.getBoolean("redelivered");
                long replyToId = set.getLong("reply_to_id");
                long timestamp = set.getLong("timestamp");
                String type = set.getString("type");
                JmsDestination destination = this._destinations.get(destinationId);
                message.setJMSMessageID(messageId);
                message.setJMSCorrelationID(correlationId);
                message.setJMSDeliveryMode(deliveryMode);
                message.setJMSDestination((Destination)destination);
                message.setJMSExpiration(expiration);
                message.setJMSPriority(priority);
                message.setJMSRedelivered(redelivered);
                if (replyToId != 0L) {
                    JmsDestination replyTo = this._destinations.get(replyToId);
                    message.setJMSReplyTo((Destination)replyTo);
                }
                message.setJMSTimestamp(timestamp);
                message.setJMSType(type);
                Blob blob = set.getBlob("body");
                try {
                    body = this.deserialize(blob);
                }
                catch (Exception exception) {
                    throw new PersistenceException("Failed to deserialize message body, JMSMessageID=" + messageId, (Throwable)exception);
                }
                this.setBody(body, message);
            }
            catch (SQLException exception) {
                throw new PersistenceException("Failed to populate message, JMSMessageID=" + messageId, (Throwable)exception);
            }
            Object var23_19 = null;
        }
        catch (Throwable throwable) {
            Object var23_20 = null;
            SQLHelper.close(set);
            SQLHelper.close((Statement)select);
            throw throwable;
        }
        SQLHelper.close((ResultSet)set);
        SQLHelper.close((Statement)select);
        this.getProperties(messageId, message);
    }

    protected void getProperties(String messageId, Message message) throws JMSException, PersistenceException {
        Map properties = this.getProperties(messageId);
        Iterator iterator = properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            message.setObjectProperty(name, value);
        }
    }

    protected void add(Message message, String type) throws JMSException, PersistenceException {
        PreparedStatement insert = null;
        String messageId = null;
        try {
            try {
                byte[] blob;
                insert = this._connection.prepareStatement("insert into openjms_pmsg values  (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                messageId = message.getJMSMessageID();
                long destinationId = this._destinations.getId((JmsDestination)message.getJMSDestination());
                insert.setString(1, messageId);
                insert.setString(2, type);
                insert.setString(3, message.getJMSCorrelationID());
                insert.setInt(4, message.getJMSDeliveryMode());
                insert.setLong(5, destinationId);
                insert.setLong(6, message.getJMSExpiration());
                insert.setInt(7, message.getJMSPriority());
                insert.setBoolean(8, message.getJMSRedelivered());
                long replyToId = 0L;
                if (message.getJMSReplyTo() != null) {
                    JmsDestination replyTo = (JmsDestination)message.getJMSReplyTo();
                    replyToId = this._destinations.getId(replyTo);
                }
                insert.setLong(9, replyToId);
                insert.setLong(10, message.getJMSTimestamp());
                insert.setString(11, message.getJMSType());
                Object body = this.getBody(message);
                try {
                    blob = this.serialize(body);
                }
                catch (Exception exception) {
                    throw new PersistenceException("Failed to serialize message body, JMSMessageID=" + messageId, (Throwable)exception);
                }
                insert.setObject(12, blob);
                insert.executeUpdate();
                Enumeration iterator = message.getPropertyNames();
                while (iterator.hasMoreElements()) {
                    String name = (String)iterator.nextElement();
                    Object value = message.getObjectProperty(name);
                    this.addProperty(messageId, name, value);
                }
                this._connection.commit();
            }
            catch (SQLException exception) {
                throw new PersistenceException("Failed to add message, JMSMessageID=" + messageId, (Throwable)exception);
            }
            Object var15_14 = null;
        }
        catch (Throwable throwable) {
            Object var15_15 = null;
            SQLHelper.close((Statement)insert);
            throw throwable;
        }
        SQLHelper.close((Statement)insert);
    }

    protected Map getProperties(String messageId) throws PersistenceException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        PreparedStatement select = null;
        ResultSet set = null;
        try {
            try {
                select = this._connection.prepareStatement("select name, value from openjms_pmsg_props where message_id = ?");
                select.setString(1, messageId);
                set = select.executeQuery();
                while (set.next()) {
                    Object value;
                    String name = set.getString("name");
                    Blob blob = set.getBlob("value");
                    try {
                        value = this.deserialize(blob);
                    }
                    catch (Exception exception) {
                        String message = "Failed to destream property for message, JMSMessageID=" + messageId + ", property=" + name;
                        throw new PersistenceException(message, (Throwable)exception);
                    }
                    result.put(name, value);
                }
            }
            catch (SQLException exception) {
                throw new PersistenceException("Failed to get properties for message, JMSMessageID=" + messageId, (Throwable)exception);
            }
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            SQLHelper.close(set);
            SQLHelper.close((Statement)select);
            throw throwable;
        }
        SQLHelper.close((ResultSet)set);
        SQLHelper.close((Statement)select);
        return result;
    }

    protected void addProperty(String messageId, String name, Object value) throws PersistenceException {
        byte[] blob;
        try {
            blob = this.serialize(value);
        }
        catch (IOException exception) {
            String message = "Failed to serialize property for message, JMSMessageID=" + messageId + ", name=" + name;
            if (value != null) {
                message = message + " of type " + value.getClass().getName();
            }
            throw new PersistenceException(message, (Throwable)exception);
        }
        PreparedStatement insert = null;
        try {
            try {
                insert = this._connection.prepareStatement("insert into openjms_pmsg_props values (?, ?, ?)");
                insert.setString(1, messageId);
                insert.setString(2, name);
                insert.setObject(3, blob);
                insert.executeUpdate();
            }
            catch (SQLException exception) {
                throw new PersistenceException("Failed to add property for message, JMSMessageID=" + messageId + ", name=" + name + ", value=" + value, (Throwable)exception);
            }
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            SQLHelper.close((Statement)insert);
            throw throwable;
        }
        SQLHelper.close((Statement)insert);
    }

    public byte[] serialize(Object object) throws IOException {
        ByteArrayOutputStream bstream = new ByteArrayOutputStream();
        ObjectOutputStream ostream = new ObjectOutputStream(bstream);
        ostream.writeObject(object);
        ostream.close();
        byte[] result = bstream.toByteArray();
        return result;
    }

    protected Object deserialize(Blob blob) throws ClassNotFoundException, IOException, SQLException {
        Object result = null;
        if (blob != null) {
            ObjectInputStream istream = new ObjectInputStream(blob.getBinaryStream());
            result = istream.readObject();
            istream.close();
        }
        return result;
    }

    protected Connection getConnection() {
        return this._connection;
    }
}

