/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.tools.migration.proxy;

import java.sql.Connection;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import org.exolab.jms.message.BytesMessageImpl;
import org.exolab.jms.persistence.PersistenceException;
import org.exolab.jms.tools.migration.proxy.AbstractMessageHandler;
import org.exolab.jms.tools.migration.proxy.DestinationStore;

class BytesMessageHandler
extends AbstractMessageHandler {
    public BytesMessageHandler(DestinationStore destinations, Connection connection) {
        super(destinations, connection);
    }

    protected String getType() {
        return "BytesMessage";
    }

    protected Message newMessage() throws JMSException {
        return new BytesMessageImpl();
    }

    protected void setBody(Object body, Message message) throws JMSException, PersistenceException {
        if (body != null && !(body instanceof byte[])) {
            throw new JMSException("Expected byte[] body for BytesMessage with JMSMessageID=" + message.getJMSMessageID() + " but got type " + body.getClass().getName());
        }
        BytesMessage bytes = (BytesMessage)message;
        bytes.writeBytes((byte[])body);
    }

    protected Object getBody(Message message) throws JMSException {
        BytesMessage bytes = (BytesMessage)message;
        bytes.reset();
        long length = bytes.getBodyLength();
        if (length > Integer.MAX_VALUE) {
            throw new JMSException("Can't handle BytesMessage, JMSMessageID=" + message.getJMSMessageID() + ", length=" + length + " - message too large ");
        }
        byte[] result = new byte[(int)length];
        if (bytes.readBytes(result) != result.length) {
            throw new JMSException("Failed to read BytesMessage");
        }
        return result;
    }
}

