/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.tools.migration.proxy;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jms.JMSException;
import org.exolab.jms.client.JmsDestination;
import org.exolab.jms.client.JmsQueue;
import org.exolab.jms.persistence.PersistenceException;
import org.exolab.jms.persistence.SQLHelper;
import org.exolab.jms.tools.migration.Store;
import org.exolab.jms.tools.migration.StoreIterator;
import org.exolab.jms.tools.migration.proxy.Consumer;
import org.exolab.jms.tools.migration.proxy.DBConstants;
import org.exolab.jms.tools.migration.proxy.DestinationStore;
import org.exolab.jms.tools.migration.proxy.MessageState;
import org.exolab.jms.tools.migration.proxy.Subscription;

public class ConsumerStore
implements Store,
DBConstants {
    private final DestinationStore _destinations;
    private final Connection _connection;
    private long _seed = 0L;

    public ConsumerStore(DestinationStore destinations, Connection connection) {
        this._destinations = destinations;
        this._connection = connection;
    }

    public StoreIterator exportCollection() throws JMSException, PersistenceException {
        List consumerIds = this.getConsumerIds();
        return new ConsumerIterator(consumerIds);
    }

    public void importCollection(StoreIterator iterator) throws JMSException, PersistenceException {
        while (iterator.hasNext()) {
            Consumer consumer = (Consumer)iterator.next();
            this.add(consumer);
        }
    }

    public int size() throws PersistenceException {
        return this.getConsumerIds().size();
    }

    public synchronized void add(Consumer consumer) throws PersistenceException {
        PreparedStatement insert = null;
        try {
            try {
                long consumerId = ++this._seed;
                insert = this._connection.prepareStatement("insert into openjms_pcons values (?, ?, ?, ?)");
                insert.setLong(1, consumerId);
                insert.setString(2, consumer.getName());
                insert.setString(3, consumer.getClientID());
                insert.setBoolean(4, consumer.isQueueConsumer());
                insert.executeUpdate();
                this.addSubscriptions(consumerId, consumer);
            }
            catch (SQLException exception) {
                throw new PersistenceException("Failed to add consumer", (Throwable)exception);
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            SQLHelper.close(insert);
            throw throwable;
        }
        SQLHelper.close((Statement)insert);
    }

    public Consumer get(long consumerId) throws PersistenceException {
        Consumer result = null;
        PreparedStatement select = null;
        ResultSet set = null;
        try {
            block4: {
                try {
                    select = this._connection.prepareStatement("select name, client_id, queue_consumer from openjms_pcons where consumer_id = ?");
                    select.setLong(1, consumerId);
                    set = select.executeQuery();
                    if (!set.next()) break block4;
                    String name = set.getString(1);
                    String clientId = set.getString(2);
                    boolean isQueue = set.getBoolean(3);
                    result = isQueue ? new Consumer(new JmsQueue(name)) : new Consumer(name, clientId);
                    this.getSubscriptions(consumerId, result);
                }
                catch (SQLException exception) {
                    throw new PersistenceException("Failed to get consumer", (Throwable)exception);
                }
            }
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            SQLHelper.close(set);
            SQLHelper.close((Statement)select);
            throw throwable;
        }
        SQLHelper.close((ResultSet)set);
        SQLHelper.close((Statement)select);
        return result;
    }

    public List getConsumerIds() throws PersistenceException {
        ArrayList<Long> result = new ArrayList<Long>();
        PreparedStatement select = null;
        ResultSet set = null;
        try {
            try {
                select = this._connection.prepareStatement("select consumer_id from openjms_pcons");
                set = select.executeQuery();
                while (set.next()) {
                    long consumerId = set.getLong("consumer_id");
                    result.add(new Long(consumerId));
                }
            }
            catch (SQLException exception) {
                throw new PersistenceException("Failed to retrieve consumer identifiers", (Throwable)exception);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            SQLHelper.close(set);
            SQLHelper.close((Statement)select);
            throw throwable;
        }
        SQLHelper.close((ResultSet)set);
        SQLHelper.close((Statement)select);
        return result;
    }

    protected void addSubscriptions(long consumerId, Consumer consumer) throws PersistenceException {
        Iterator iterator = consumer.getSubscriptions().iterator();
        while (iterator.hasNext()) {
            Object var11_7;
            Subscription subscription = (Subscription)iterator.next();
            long destinationId = this._destinations.getId(subscription.getDestination());
            if (destinationId == -1L) {
                throw new PersistenceException("Destination identifier not found for destination=" + subscription.getDestination().getName());
            }
            PreparedStatement insert = null;
            try {
                try {
                    insert = this._connection.prepareStatement("insert into openjms_psubs values (?, ?)");
                    insert.setLong(1, consumerId);
                    insert.setLong(2, destinationId);
                    insert.executeUpdate();
                }
                catch (SQLException exception) {
                    throw new PersistenceException("Failed to insert subscription", (Throwable)exception);
                }
                var11_7 = null;
            }
            catch (Throwable throwable) {
                var11_7 = null;
                SQLHelper.close((Statement)insert);
                throw throwable;
            }
            SQLHelper.close((Statement)insert);
            this.addMessages(consumerId, destinationId, subscription);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void addMessages(long consumerId, long destinationId, Subscription subscription) throws PersistenceException {
        Iterator iterator = subscription.getMessages().iterator();
        while (iterator.hasNext()) {
            Object var11_7;
            MessageState message = (MessageState)iterator.next();
            PreparedStatement insert = null;
            try {
                try {
                    insert = this._connection.prepareStatement("insert into openjms_phdl (message_id, destination_id, consumer_id, delivered) values (?, ?, ?, ?)");
                    insert.setString(1, message.getMessageId());
                    insert.setLong(2, destinationId);
                    insert.setLong(3, consumerId);
                    insert.setBoolean(4, message.getDelivered());
                    insert.executeUpdate();
                }
                catch (SQLException exception) {
                    throw new PersistenceException("Failed to insert subscription state", (Throwable)exception);
                }
                var11_7 = null;
            }
            catch (Throwable throwable) {
                var11_7 = null;
                SQLHelper.close((Statement)insert);
                throw throwable;
            }
            SQLHelper.close((Statement)insert);
        }
        return;
    }

    protected void getSubscriptions(long consumerId, Consumer consumer) throws PersistenceException {
        PreparedStatement select = null;
        ResultSet set = null;
        try {
            try {
                select = this._connection.prepareStatement("select destination_id from openjms_psubs where consumer_id = ?");
                select.setLong(1, consumerId);
                set = select.executeQuery();
                while (set.next()) {
                    long destinationId = set.getLong("destination_id");
                    JmsDestination destination = this._destinations.get(destinationId);
                    if (destination == null) {
                        throw new PersistenceException("Failed to locate destination for id=" + destinationId);
                    }
                    Subscription subscription = new Subscription(destination);
                    this.getMessages(consumerId, destinationId, subscription);
                    consumer.addSubscription(subscription);
                }
            }
            catch (SQLException exception) {
                throw new PersistenceException("Failed to get subscriptions for consumer=" + consumerId, (Throwable)exception);
            }
            Object var11_9 = null;
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            SQLHelper.close(set);
            SQLHelper.close((Statement)select);
            throw throwable;
        }
        SQLHelper.close((ResultSet)set);
        SQLHelper.close((Statement)select);
    }

    protected void getMessages(long consumerId, long destinationId, Subscription subscription) throws SQLException {
        PreparedStatement select = null;
        ResultSet set = null;
        try {
            select = this._connection.prepareStatement("select message_id, delivered from openjms_phdl where consumer_id = ? and destination_id = ?");
            select.setLong(1, consumerId);
            select.setLong(2, destinationId);
            set = select.executeQuery();
            while (set.next()) {
                String messageId = set.getString("message_id");
                boolean delivered = set.getBoolean("delivered");
                subscription.addMessage(messageId, delivered);
            }
            Object var11_8 = null;
        }
        catch (Throwable throwable) {
            Object var11_9 = null;
            SQLHelper.close(set);
            SQLHelper.close((Statement)select);
            throw throwable;
        }
        SQLHelper.close((ResultSet)set);
        SQLHelper.close((Statement)select);
    }

    private class ConsumerIterator
    implements StoreIterator {
        private Iterator _iterator;

        public ConsumerIterator(List consumerIds) {
            this._iterator = consumerIds.iterator();
        }

        public boolean hasNext() {
            return this._iterator.hasNext();
        }

        public Object next() throws PersistenceException {
            Consumer result = null;
            Long consumerId = (Long)this._iterator.next();
            result = ConsumerStore.this.get(consumerId);
            return result;
        }
    }
}

