/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.tools.migration.proxy;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.jms.JMSException;
import org.exolab.jms.client.JmsDestination;
import org.exolab.jms.client.JmsQueue;
import org.exolab.jms.client.JmsTopic;
import org.exolab.jms.persistence.PersistenceException;
import org.exolab.jms.persistence.SQLHelper;
import org.exolab.jms.tools.migration.IteratorAdapter;
import org.exolab.jms.tools.migration.Store;
import org.exolab.jms.tools.migration.StoreIterator;
import org.exolab.jms.tools.migration.proxy.DBConstants;

public class DestinationStore
implements Store,
DBConstants {
    private final Connection _connection;
    private final HashMap _destinations = new HashMap();
    private final HashMap _ids = new HashMap();
    private long _seed = 0L;

    public DestinationStore(Connection connection) throws PersistenceException {
        this._connection = connection;
        this.load();
    }

    public StoreIterator exportCollection() throws JMSException, PersistenceException {
        List destinations = this.getDestinations();
        return new IteratorAdapter(destinations.iterator());
    }

    public void importCollection(StoreIterator iterator) throws JMSException, PersistenceException {
        while (iterator.hasNext()) {
            JmsDestination destination = (JmsDestination)iterator.next();
            this.add(destination);
        }
    }

    public int size() throws PersistenceException {
        return this._destinations.size();
    }

    public synchronized void add(JmsDestination destination) throws PersistenceException {
        PreparedStatement insert = null;
        try {
            try {
                long destinationId = ++this._seed;
                String name = destination.getName();
                boolean isQueue = destination instanceof JmsQueue;
                insert = this._connection.prepareStatement("insert into openjms_pdest values (?, ?, ?)");
                insert.setLong(1, destinationId);
                insert.setString(2, name);
                insert.setBoolean(3, isQueue);
                insert.executeUpdate();
                this.cache(destination, destinationId);
            }
            catch (SQLException exception) {
                throw new PersistenceException("Failed to add destination=" + destination.getName(), (Throwable)exception);
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            SQLHelper.close(insert);
            throw throwable;
        }
        SQLHelper.close((Statement)insert);
    }

    public synchronized JmsDestination get(long destinationId) {
        Pair pair = (Pair)this._ids.get(new Long(destinationId));
        return pair != null ? pair.destination : null;
    }

    public synchronized long getId(JmsDestination destination) {
        Pair pair = (Pair)this._destinations.get(destination.getName());
        return pair != null ? pair.destinationId : -1L;
    }

    public synchronized List getDestinations() {
        ArrayList<JmsDestination> result = new ArrayList<JmsDestination>(this._destinations.size());
        Iterator iterator = this._destinations.values().iterator();
        while (iterator.hasNext()) {
            Pair pair = (Pair)iterator.next();
            result.add(pair.destination);
        }
        return result;
    }

    protected void load() throws PersistenceException {
        PreparedStatement select = null;
        ResultSet set = null;
        try {
            try {
                select = this._connection.prepareStatement("select * from openjms_pdest");
                set = select.executeQuery();
                while (set.next()) {
                    long destinationId = set.getLong("destination_id");
                    String name = set.getString("name");
                    boolean isQueue = set.getBoolean("is_queue");
                    JmsQueue destination = isQueue ? new JmsQueue(name) : new JmsTopic(name);
                    destination.setPersistent(true);
                    this.cache((JmsDestination)destination, destinationId);
                }
            }
            catch (SQLException exception) {
                throw new PersistenceException("FGailed to load destinations", (Throwable)exception);
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            SQLHelper.close(set);
            SQLHelper.close((Statement)select);
            throw throwable;
        }
        SQLHelper.close((ResultSet)set);
        SQLHelper.close((Statement)select);
    }

    private void cache(JmsDestination destination, long destinationId) {
        Pair pair = new Pair(destination, destinationId);
        this._destinations.put(destination.getName(), pair);
        this._ids.put(new Long(destinationId), pair);
    }

    private static class Pair {
        public JmsDestination destination;
        public long destinationId;

        public Pair(JmsDestination destination, long destinationId) {
            this.destination = destination;
            this.destinationId = destinationId;
        }
    }
}

