/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.tools.migration.proxy;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.Message;
import org.exolab.jms.persistence.PersistenceException;
import org.exolab.jms.persistence.SQLHelper;
import org.exolab.jms.tools.migration.Store;
import org.exolab.jms.tools.migration.StoreIterator;
import org.exolab.jms.tools.migration.proxy.DBConstants;
import org.exolab.jms.tools.migration.proxy.DestinationStore;
import org.exolab.jms.tools.migration.proxy.MessageHandler;
import org.exolab.jms.tools.migration.proxy.MessageHandlerFactory;

public class MessageStore
implements Store,
DBConstants {
    private final DestinationStore _destinations;
    private final Connection _connection;

    public MessageStore(DestinationStore destinations, Connection connection) {
        this._destinations = destinations;
        this._connection = connection;
    }

    public StoreIterator exportCollection() throws JMSException, PersistenceException {
        List messageIds = this.getMessageIds();
        return new MessageIterator(messageIds);
    }

    public void importCollection(StoreIterator iterator) throws JMSException, PersistenceException {
        while (iterator.hasNext()) {
            Message message = (Message)iterator.next();
            this.add(message);
        }
    }

    public int size() throws PersistenceException {
        return this.getMessageIds().size();
    }

    public synchronized void add(Message message) throws JMSException, PersistenceException {
        MessageHandler handler = MessageHandlerFactory.create(message, this._destinations, this._connection);
        handler.add(message);
    }

    public Message get(String messageId) throws JMSException, PersistenceException {
        Message result = null;
        PreparedStatement select = null;
        ResultSet set = null;
        try {
            block4: {
                try {
                    select = this._connection.prepareStatement("select message_type from openjms_pmsg where message_id = ?");
                    select.setString(1, messageId);
                    set = select.executeQuery();
                    if (!set.next()) break block4;
                    String type = set.getString("message_type");
                    String qualifiedType = "javax.jms." + type;
                    MessageHandler handler = MessageHandlerFactory.create(qualifiedType, this._destinations, this._connection);
                    result = handler.get(messageId);
                }
                catch (SQLException exception) {
                    throw new PersistenceException("Failed to get message with JMSMessageID=" + messageId, (Throwable)exception);
                }
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            SQLHelper.close(set);
            SQLHelper.close((Statement)select);
            throw throwable;
        }
        SQLHelper.close((ResultSet)set);
        SQLHelper.close((Statement)select);
        return result;
    }

    public List getMessageIds() throws PersistenceException {
        ArrayList<String> result = new ArrayList<String>();
        PreparedStatement select = null;
        ResultSet set = null;
        try {
            try {
                select = this._connection.prepareStatement("select message_id from openjms_pmsg");
                set = select.executeQuery();
                while (set.next()) {
                    String messageId = set.getString("message_id");
                    result.add(messageId);
                }
            }
            catch (SQLException exception) {
                throw new PersistenceException("Failed to get message ids", (Throwable)exception);
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            SQLHelper.close(set);
            SQLHelper.close((Statement)select);
            throw throwable;
        }
        SQLHelper.close((ResultSet)set);
        SQLHelper.close((Statement)select);
        return result;
    }

    private class MessageIterator
    implements StoreIterator {
        private Iterator _iterator;

        public MessageIterator(List messageIds) {
            this._iterator = messageIds.iterator();
        }

        public boolean hasNext() {
            return this._iterator.hasNext();
        }

        public Object next() throws JMSException, PersistenceException {
            String messageId = (String)this._iterator.next();
            return MessageStore.this.get(messageId);
        }
    }
}

