/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.tools.migration.proxy;

import java.io.Serializable;
import java.sql.Connection;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import org.exolab.jms.message.ObjectMessageImpl;
import org.exolab.jms.persistence.PersistenceException;
import org.exolab.jms.tools.migration.proxy.AbstractMessageHandler;
import org.exolab.jms.tools.migration.proxy.DestinationStore;

class ObjectMessageHandler
extends AbstractMessageHandler {
    public ObjectMessageHandler(DestinationStore destinations, Connection connection) {
        super(destinations, connection);
    }

    protected String getType() {
        return "ObjectMessage";
    }

    protected Message newMessage() throws JMSException {
        return new ObjectMessageImpl();
    }

    protected void setBody(Object body, Message message) throws JMSException, PersistenceException {
        if (body != null) {
            ObjectMessage object = (ObjectMessage)message;
            if (!(body instanceof Serializable)) {
                throw new JMSException("Expected Serializable object for ObjectMessage with JMSMessageID=" + message.getJMSMessageID() + " but got type " + body.getClass().getName());
            }
            object.setObject((Serializable)body);
        }
    }

    protected Object getBody(Message message) throws JMSException {
        ObjectMessage object = (ObjectMessage)message;
        return object.getObject();
    }
}

