/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.tools.migration.proxy;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageEOFException;
import javax.jms.StreamMessage;
import org.exolab.jms.message.StreamMessageImpl;
import org.exolab.jms.persistence.PersistenceException;
import org.exolab.jms.tools.migration.proxy.AbstractMessageHandler;
import org.exolab.jms.tools.migration.proxy.DestinationStore;

class StreamMessageHandler
extends AbstractMessageHandler {
    public StreamMessageHandler(DestinationStore destinations, Connection connection) {
        super(destinations, connection);
    }

    protected String getType() {
        return "StreamMessage";
    }

    protected Message newMessage() throws JMSException {
        return new StreamMessageImpl();
    }

    protected void setBody(Object body, Message message) throws JMSException, PersistenceException {
        if (body == null) {
            throw new JMSException("Expected non-null body for StreamMessage with JMSMessageID=" + message.getJMSMessageID());
        }
        if (!(body instanceof List)) {
            throw new JMSException("Expected List body for StreamMessage with JMSMessageID=" + message.getJMSMessageID() + " but got type " + body.getClass().getName());
        }
        StreamMessage msg = (StreamMessage)message;
        List list = (List)body;
        Iterator i = list.iterator();
        while (i.hasNext()) {
            Object value = i.next();
            msg.writeObject(value);
        }
    }

    protected Object getBody(Message message) throws JMSException {
        StreamMessage msg = (StreamMessage)message;
        msg.reset();
        ArrayList<Object> result = new ArrayList<Object>();
        while (true) {
            try {
                Object value = msg.readObject();
                result.add(value);
            }
            catch (MessageEOFException exception) {
                return result;
            }
        }
    }
}

