/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.tools.migration.proxy;

import java.sql.Connection;
import javax.jms.JMSException;
import javax.jms.Message;
import org.exolab.jms.message.TextMessageImpl;
import org.exolab.jms.persistence.PersistenceException;
import org.exolab.jms.tools.migration.proxy.AbstractMessageHandler;
import org.exolab.jms.tools.migration.proxy.DestinationStore;

class TextMessageHandler
extends AbstractMessageHandler {
    public TextMessageHandler(DestinationStore destinations, Connection connection) {
        super(destinations, connection);
    }

    protected String getType() {
        return "TextMessage";
    }

    protected Message newMessage() throws JMSException {
        return new TextMessageImpl();
    }

    protected Object getBody(Message message) throws JMSException {
        return ((TextMessageImpl)message).getText();
    }

    protected void setBody(Object body, Message message) throws JMSException, PersistenceException {
        if (body != null && !(body instanceof String)) {
            throw new JMSException("Expected String body for TextMessage with JMSMessageID=" + message.getJMSMessageID() + " but got type " + body.getClass().getName());
        }
        TextMessageImpl text = (TextMessageImpl)message;
        text.setText((String)body);
    }
}

