/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.tools.migration.proxy;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.jms.JMSException;
import org.exolab.jms.authentication.User;
import org.exolab.jms.persistence.PersistenceException;
import org.exolab.jms.persistence.SQLHelper;
import org.exolab.jms.tools.migration.IteratorAdapter;
import org.exolab.jms.tools.migration.Store;
import org.exolab.jms.tools.migration.StoreIterator;
import org.exolab.jms.tools.migration.proxy.DBConstants;

public class UserStore
implements Store,
DBConstants {
    private final Connection _connection;

    public UserStore(Connection connection) {
        this._connection = connection;
    }

    public StoreIterator exportCollection() throws JMSException, PersistenceException {
        List users = this.getUsers();
        return new IteratorAdapter(users.iterator());
    }

    public void importCollection(StoreIterator iterator) throws JMSException, PersistenceException {
        while (iterator.hasNext()) {
            User user = (User)iterator.next();
            this.add(user);
        }
    }

    public int size() throws PersistenceException {
        return this.getUsers().size();
    }

    private void add(User user) throws PersistenceException {
        PreparedStatement insert = null;
        try {
            try {
                insert = this._connection.prepareStatement("insert into openjms_puser values (?, ?)");
                insert.setString(1, user.getUsername());
                insert.setString(2, user.getPassword());
                insert.executeUpdate();
            }
            catch (SQLException exception) {
                throw new PersistenceException("Failed to add consumer", (Throwable)exception);
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            SQLHelper.close((Statement)insert);
            throw throwable;
        }
        SQLHelper.close((Statement)insert);
    }

    private List getUsers() throws PersistenceException {
        ArrayList<User> result = new ArrayList<User>();
        PreparedStatement select = null;
        ResultSet set = null;
        try {
            try {
                select = this._connection.prepareStatement("select * from openjms_puser");
                set = select.executeQuery();
                while (set.next()) {
                    String user = set.getString("username");
                    String password = set.getString("password");
                    result.add(new User(user, password));
                }
            }
            catch (SQLException exception) {
                throw new PersistenceException("Failed to retrieve users", (Throwable)exception);
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            SQLHelper.close(set);
            SQLHelper.close((Statement)select);
            throw throwable;
        }
        SQLHelper.close((ResultSet)set);
        SQLHelper.close((Statement)select);
        return result;
    }
}

