#ifndef __ANNUAIRE_H__
#define __ANNUAIRE_H__

/*
 * Structures de donnees
 */
typedef struct sPersonne {
	char nom[256];
	char prenom[256];
	char tel[32];
	char eMail[256];
	char adresse[1024];
} Personne;

typedef struct sAnnuaire {
	Personne *pers;
	struct sAnnuaire *suivant;
} Annuaire;


/*
 * Creation et/ou chargement de l'annuaire
 *
 * nomFichier : nom du fichier stockant l'annuaire
 *
 * renvoie l'annuaire charge ou cree
 */
Annuaire *creationChargement(char *nomFichier);

/*
 * Sauvegarde l'annuaire
 *
 * annu : annuaire
 * nomFichier : nom du fichier stockant l'annuaire
 *
 * renvoie 0 : si ok, -1 : si annu est vide, -2 : si erreur fichier
 */
int sauvegarde(Annuaire *annu, char *nomFichier);

/*
 * Ajout d'une personne dans l'annuaire
 *
 * annu : annuaire
 * nom : nom de la personne
 * prenom : prenom de la personne
 * tel : numero de tel de la personne
 * eMail : adresse e-mail de la personne
 * adresse : adresse de la personne
 *
 * renvoie 0 : si ok, -1 : si annu est NULL, -2 : si nom est deja present
 */
int ajout(Annuaire *annu, char *nom, char *prenom, char * tel,
	  char *eMail, char *adresse);

/*
 * Effacement d'une entree de l'annuaire
 *
 * annu : annuaire
 * nom : nom de la personne
 *
 * renvoie 0 : si ok, -1 : si nom n'est pas present
 */
int effacement(Annuaire **annu, char *nom);

/*
 * Recherche d'une entree dans l'annuaire
 *
 * annu : annuaire
 * nom : nom de la personne
 *
 * renvoie la personne ou NULL : si nom n'est pas present
 */
Personne *recherche(Annuaire *annu, char *nom);

/*
 * Modification du prenom
 *
 * annu : annuaire
 * nom : nom de la personne
 * prenom : nouveau prenom
 *
 * renvoie 0 : si ok, -1 : si nom n'est pas present
 */
int modifPrenom(Annuaire *annu, char *nom, char *prenom);

/*
 * Modification du tel
 *
 * annu : annuaire
 * nom : nom de la personne
 * tel : nouveau tel
 *
 * renvoie 0 : si ok, -1 : si nom n'est pas present
 */
int modifTel(Annuaire *annu, char *nom, char *tel);

/*
 * Modification de l'e-mail
 *
 * annu : annuaire
 * nom : nom de la personne
 * eMail : nouvel e-mail
 *
 * renvoie 0 : si ok, -1 : si nom n'est pas present
 */
int modifEMail(Annuaire *annu, char *nom, char *eMail);

/*
 * Modification de l'adresse
 *
 * annu : annuaire
 * nom : nom de la personne
 * adresse : nouvelle adresse
 *
 * renvoie 0 : si ok, -1 : si nom n'est pas present
 */
int modifAdresse(Annuaire *annu, char *nom, char *adresse);

/*
 * Affiche l'annuaire
 *
 * annu : annuaire
 */
void affiche(Annuaire *annu);

/*
 * Affiche une personne
 *
 * p : personne
 */
void affichePersonne(Personne *p);

#endif