#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "client.h"

/*
 * affiche le menu
 */
void afficheMenu() {
	printf("Choisissez une action: \n");
	printf("1 - ajouter\n");
	printf("2 - effacer\n");
	printf("3 - modifier prenom\n");
	printf("4 - modifier tel\n");
	printf("5 - modifier e-mail\n");
	printf("6 - modifier adresse\n");
	printf("7 - rechercher\n");
	printf("0 - quitter\n");
}

/*
 * gère un ajout à l'annuaire
 */
void gererAjouter() {
	char nom[256];
	char prenom[256];
	char tel[32];
	char eMail[256];
	char adresse[1024];
	char requete[4096];
	char *reponse;
	do {
		printf("Tapez le nom : ");
	} while(fgets(nom, 256, stdin) == NULL);
	/* enlever le \n */
	nom[strlen(nom)-1]='\0';
	do {
		printf("Tapez le prenom : ");
	} while(fgets(prenom, 256, stdin) == NULL);
	/* enlever le \n */
	prenom[strlen(prenom)-1]='\0';
	do {
		printf("Tapez le tel : ");
	} while(fgets(tel, 32, stdin) == NULL);
	/* enlever le \n */
	tel[strlen(tel)-1]='\0';
	do {
		printf("Tapez l'e-mail : ");
	} while(fgets(eMail, 256, stdin) == NULL);
	/* enlever le \n */
	eMail[strlen(eMail)-1]='\0';
	do {
		printf("Tapez l'adresse : ");
	} while(fgets(adresse, 1024, stdin) == NULL);
	/* enlever le \n */
	adresse[strlen(adresse)-1]='\0';

	sprintf(requete, "AJOUT %s|%s|%s|%s|%s\n", nom, prenom, tel, eMail, adresse);

	Emission(requete);

	reponse = Reception();
	printf("J'ai recu: %s\n", reponse);
	free(reponse);
}

/*
 * gère un effacement dans l'annuaire
 */
void gererEffacer() {
	char nom[256];
	char requete[4096];
	char *reponse;
	do {
		printf("Tapez le nom : ");
	} while(fgets(nom, 256, stdin) == NULL);
	/* enlever le \n */
	nom[strlen(nom)-1]='\0';

	sprintf(requete, "EFFACE %s\n", nom);

	Emission(requete);

	reponse = Reception();
	printf("J'ai recu: %s\n", reponse);
	free(reponse);
}

/*
 * gère une modif de prénom dans l'annuaire
 */
void gererModifPrenom() {
	char nom[256];
	char prenom[256];
	char requete[4096];
	char *reponse;
	do {
		printf("Tapez le nom : ");
	} while(fgets(nom, 256, stdin) == NULL);
	/* enlever le \n */
	nom[strlen(nom)-1]='\0';
	do {
		printf("Tapez le nouveau prenom : ");
	} while(fgets(prenom, 256, stdin) == NULL);
	/* enlever le \n */
	prenom[strlen(prenom)-1]='\0';

	sprintf(requete, "MODIF_PRENOM %s|%s\n", nom, prenom);

	Emission(requete);

	reponse = Reception();
	printf("J'ai recu: %s\n", reponse);
	free(reponse);
}

/*
 * gère une modif de tel dans l'annuaire
 */
void gererModifTel() {
	char nom[256];
	char tel[32];
	char requete[4096];
	char *reponse;
	do {
		printf("Tapez le nom : ");
	} while(fgets(nom, 256, stdin) == NULL);
	/* enlever le \n */
	nom[strlen(nom)-1]='\0';
	do {
		printf("Tapez le nouveau tel : ");
	} while(fgets(tel, 32, stdin) == NULL);
	/* enlever le \n */
	tel[strlen(tel)-1]='\0';

	sprintf(requete, "MODIF_TEL %s|%s\n", nom, tel);

	Emission(requete);

	reponse = Reception();
	printf("J'ai recu: %s\n", reponse);
	free(reponse);
}

/*
 * gère une modif d'e-mail dans l'annuaire
 */
void gererModifEMail() {
	char nom[256];
	char eMail[256];
	char requete[4096];
	char *reponse;
	do {
		printf("Tapez le nom : ");
	} while(fgets(nom, 256, stdin) == NULL);
	/* enlever le \n */
	nom[strlen(nom)-1]='\0';
	do {
		printf("Tapez le nouvel e-mail : ");
	} while(fgets(eMail, 256, stdin) == NULL);
	/* enlever le \n */
	eMail[strlen(eMail)-1]='\0';

	sprintf(requete, "MODIF_EMAIL %s|%s\n", nom, eMail);

	Emission(requete);

	reponse = Reception();
	printf("J'ai recu: %s\n", reponse);
	free(reponse);
}

/*
 * gère une modif d'adresse dans l'annuaire
 */
void gererModifAdresse() {
	char nom[256];
	char adresse[1024];
	char requete[4096];
	char *reponse;
	do {
		printf("Tapez le nom : ");
	} while(fgets(nom, 256, stdin) == NULL);
	/* enlever le \n */
	nom[strlen(nom)-1]='\0';
	do {
		printf("Tapez la nouvelle adresse : ");
	} while(fgets(adresse, 1024, stdin) == NULL);
	/* enlever le \n */
	adresse[strlen(adresse)-1]='\0';

	sprintf(requete, "MODIF_ADRESSE %s|%s\n", nom, adresse);

	Emission(requete);

	reponse = Reception();
	printf("J'ai recu: %s\n", reponse);
	free(reponse);
}

/*
 * gère une recherche dans l'annuaire
 */
void gererRechercher() {
	char nom[256];
	char requete[4096];
	char *reponse;
	do {
		printf("Tapez le nom : ");
	} while(fgets(nom, 256, stdin) == NULL);
	/* enlever le \n */
	nom[strlen(nom)-1]='\0';

	sprintf(requete, "RECHERCHE %s\n", nom);

	Emission(requete);

	reponse = Reception();
	printf("J'ai recu: %s\n", reponse);
	free(reponse);
}

int main() {
	char *message;
	char choix[1024];
	int fini = 0;

	Initialisation("127.0.0.1");
	while(!fini) {
		afficheMenu();
		if(fgets(choix, 1024, stdin) != NULL) {
			switch(choix[0]) {
				case '0':
					fini = 1;
					break;
				case '1':
					gererAjouter();
					break;
				case '2':
					gererEffacer();
					break;
				case '3':
					gererModifPrenom();
					break;
				case '4':
					gererModifTel();
					break;
				case '5':
					gererModifEMail();
					break;
				case '6':
					gererModifAdresse();
					break;
				case '7':
					gererRechercher();
					break;
				default:
					printf("Veuillez choisir une option correcte.\n");
			}
		} else {
			printf("Veuillez choisir une option correcte.\n");
		}
	}

	Terminaison();

	return 0;
}
